<?php
/**
 * SenderCompany
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * SenderCompany Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SenderCompany implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'senderCompany';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'anchor_allow_white_space_in_characters' => '?string',
        'anchor_allow_white_space_in_characters_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_case_sensitive' => '?string',
        'anchor_case_sensitive_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_horizontal_alignment' => '?string',
        'anchor_horizontal_alignment_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_ignore_if_not_present' => '?string',
        'anchor_ignore_if_not_present_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_match_whole_word' => '?string',
        'anchor_match_whole_word_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_string' => '?string',
        'anchor_string_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_tab_processor_version' => '?string',
        'anchor_tab_processor_version_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_units' => '?string',
        'anchor_units_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_x_offset' => '?string',
        'anchor_x_offset_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'anchor_y_offset' => '?string',
        'anchor_y_offset_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'bold' => '?string',
        'bold_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'caption' => '?string',
        'caption_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'conditional_parent_label' => '?string',
        'conditional_parent_label_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'conditional_parent_value' => '?string',
        'conditional_parent_value_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'custom_tab_id' => '?string',
        'custom_tab_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'document_id' => '?string',
        'document_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'font' => '?string',
        'font_color' => '?string',
        'font_color_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'font_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'font_size' => '?string',
        'font_size_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'form_order' => '?string',
        'form_order_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'form_page_label' => '?string',
        'form_page_label_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'form_page_number' => '?string',
        'form_page_number_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'height' => '?string',
        'height_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'italic' => '?string',
        'italic_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'locale_policy' => '\DocuSign\eSign\Model\LocalePolicyTab',
        'merge_field' => '\DocuSign\eSign\Model\MergeField',
        'merge_field_xml' => '?string',
        'name' => '?string',
        'name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'page_number' => '?string',
        'page_number_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'recipient_id' => '?string',
        'recipient_id_guid' => '?string',
        'recipient_id_guid_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'recipient_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'smart_contract_information' => '\DocuSign\eSign\Model\SmartContractInformation',
        'source' => '?string',
        'status' => '?string',
        'status_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_group_labels' => '?string[]',
        'tab_group_labels_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_id' => '?string',
        'tab_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_label' => '?string',
        'tab_label_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_order' => '?string',
        'tab_order_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tab_type' => '?string',
        'tab_type_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'template_locked' => '?string',
        'template_locked_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'template_required' => '?string',
        'template_required_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'tooltip' => '?string',
        'tool_tip_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'underline' => '?string',
        'underline_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'value' => '?string',
        'value_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'width' => '?string',
        'width_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'x_position' => '?string',
        'x_position_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'y_position' => '?string',
        'y_position_metadata' => '\DocuSign\eSign\Model\PropertyMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'anchor_allow_white_space_in_characters' => null,
        'anchor_allow_white_space_in_characters_metadata' => null,
        'anchor_case_sensitive' => null,
        'anchor_case_sensitive_metadata' => null,
        'anchor_horizontal_alignment' => null,
        'anchor_horizontal_alignment_metadata' => null,
        'anchor_ignore_if_not_present' => null,
        'anchor_ignore_if_not_present_metadata' => null,
        'anchor_match_whole_word' => null,
        'anchor_match_whole_word_metadata' => null,
        'anchor_string' => null,
        'anchor_string_metadata' => null,
        'anchor_tab_processor_version' => null,
        'anchor_tab_processor_version_metadata' => null,
        'anchor_units' => null,
        'anchor_units_metadata' => null,
        'anchor_x_offset' => null,
        'anchor_x_offset_metadata' => null,
        'anchor_y_offset' => null,
        'anchor_y_offset_metadata' => null,
        'bold' => null,
        'bold_metadata' => null,
        'caption' => null,
        'caption_metadata' => null,
        'conditional_parent_label' => null,
        'conditional_parent_label_metadata' => null,
        'conditional_parent_value' => null,
        'conditional_parent_value_metadata' => null,
        'custom_tab_id' => null,
        'custom_tab_id_metadata' => null,
        'document_id' => null,
        'document_id_metadata' => null,
        'error_details' => null,
        'font' => null,
        'font_color' => null,
        'font_color_metadata' => null,
        'font_metadata' => null,
        'font_size' => null,
        'font_size_metadata' => null,
        'form_order' => null,
        'form_order_metadata' => null,
        'form_page_label' => null,
        'form_page_label_metadata' => null,
        'form_page_number' => null,
        'form_page_number_metadata' => null,
        'height' => null,
        'height_metadata' => null,
        'italic' => null,
        'italic_metadata' => null,
        'locale_policy' => null,
        'merge_field' => null,
        'merge_field_xml' => null,
        'name' => null,
        'name_metadata' => null,
        'page_number' => null,
        'page_number_metadata' => null,
        'recipient_id' => null,
        'recipient_id_guid' => null,
        'recipient_id_guid_metadata' => null,
        'recipient_id_metadata' => null,
        'smart_contract_information' => null,
        'source' => null,
        'status' => null,
        'status_metadata' => null,
        'tab_group_labels' => null,
        'tab_group_labels_metadata' => null,
        'tab_id' => null,
        'tab_id_metadata' => null,
        'tab_label' => null,
        'tab_label_metadata' => null,
        'tab_order' => null,
        'tab_order_metadata' => null,
        'tab_type' => null,
        'tab_type_metadata' => null,
        'template_locked' => null,
        'template_locked_metadata' => null,
        'template_required' => null,
        'template_required_metadata' => null,
        'tooltip' => null,
        'tool_tip_metadata' => null,
        'underline' => null,
        'underline_metadata' => null,
        'value' => null,
        'value_metadata' => null,
        'width' => null,
        'width_metadata' => null,
        'x_position' => null,
        'x_position_metadata' => null,
        'y_position' => null,
        'y_position_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'anchor_allow_white_space_in_characters' => 'anchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'anchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'anchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'anchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'anchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'anchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'anchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'anchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'anchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'anchorMatchWholeWordMetadata',
        'anchor_string' => 'anchorString',
        'anchor_string_metadata' => 'anchorStringMetadata',
        'anchor_tab_processor_version' => 'anchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'anchorTabProcessorVersionMetadata',
        'anchor_units' => 'anchorUnits',
        'anchor_units_metadata' => 'anchorUnitsMetadata',
        'anchor_x_offset' => 'anchorXOffset',
        'anchor_x_offset_metadata' => 'anchorXOffsetMetadata',
        'anchor_y_offset' => 'anchorYOffset',
        'anchor_y_offset_metadata' => 'anchorYOffsetMetadata',
        'bold' => 'bold',
        'bold_metadata' => 'boldMetadata',
        'caption' => 'caption',
        'caption_metadata' => 'captionMetadata',
        'conditional_parent_label' => 'conditionalParentLabel',
        'conditional_parent_label_metadata' => 'conditionalParentLabelMetadata',
        'conditional_parent_value' => 'conditionalParentValue',
        'conditional_parent_value_metadata' => 'conditionalParentValueMetadata',
        'custom_tab_id' => 'customTabId',
        'custom_tab_id_metadata' => 'customTabIdMetadata',
        'document_id' => 'documentId',
        'document_id_metadata' => 'documentIdMetadata',
        'error_details' => 'errorDetails',
        'font' => 'font',
        'font_color' => 'fontColor',
        'font_color_metadata' => 'fontColorMetadata',
        'font_metadata' => 'fontMetadata',
        'font_size' => 'fontSize',
        'font_size_metadata' => 'fontSizeMetadata',
        'form_order' => 'formOrder',
        'form_order_metadata' => 'formOrderMetadata',
        'form_page_label' => 'formPageLabel',
        'form_page_label_metadata' => 'formPageLabelMetadata',
        'form_page_number' => 'formPageNumber',
        'form_page_number_metadata' => 'formPageNumberMetadata',
        'height' => 'height',
        'height_metadata' => 'heightMetadata',
        'italic' => 'italic',
        'italic_metadata' => 'italicMetadata',
        'locale_policy' => 'localePolicy',
        'merge_field' => 'mergeField',
        'merge_field_xml' => 'mergeFieldXml',
        'name' => 'name',
        'name_metadata' => 'nameMetadata',
        'page_number' => 'pageNumber',
        'page_number_metadata' => 'pageNumberMetadata',
        'recipient_id' => 'recipientId',
        'recipient_id_guid' => 'recipientIdGuid',
        'recipient_id_guid_metadata' => 'recipientIdGuidMetadata',
        'recipient_id_metadata' => 'recipientIdMetadata',
        'smart_contract_information' => 'smartContractInformation',
        'source' => 'source',
        'status' => 'status',
        'status_metadata' => 'statusMetadata',
        'tab_group_labels' => 'tabGroupLabels',
        'tab_group_labels_metadata' => 'tabGroupLabelsMetadata',
        'tab_id' => 'tabId',
        'tab_id_metadata' => 'tabIdMetadata',
        'tab_label' => 'tabLabel',
        'tab_label_metadata' => 'tabLabelMetadata',
        'tab_order' => 'tabOrder',
        'tab_order_metadata' => 'tabOrderMetadata',
        'tab_type' => 'tabType',
        'tab_type_metadata' => 'tabTypeMetadata',
        'template_locked' => 'templateLocked',
        'template_locked_metadata' => 'templateLockedMetadata',
        'template_required' => 'templateRequired',
        'template_required_metadata' => 'templateRequiredMetadata',
        'tooltip' => 'tooltip',
        'tool_tip_metadata' => 'toolTipMetadata',
        'underline' => 'underline',
        'underline_metadata' => 'underlineMetadata',
        'value' => 'value',
        'value_metadata' => 'valueMetadata',
        'width' => 'width',
        'width_metadata' => 'widthMetadata',
        'x_position' => 'xPosition',
        'x_position_metadata' => 'xPositionMetadata',
        'y_position' => 'yPosition',
        'y_position_metadata' => 'yPositionMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'anchor_allow_white_space_in_characters' => 'setAnchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'setAnchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'setAnchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'setAnchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'setAnchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'setAnchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'setAnchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'setAnchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'setAnchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'setAnchorMatchWholeWordMetadata',
        'anchor_string' => 'setAnchorString',
        'anchor_string_metadata' => 'setAnchorStringMetadata',
        'anchor_tab_processor_version' => 'setAnchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'setAnchorTabProcessorVersionMetadata',
        'anchor_units' => 'setAnchorUnits',
        'anchor_units_metadata' => 'setAnchorUnitsMetadata',
        'anchor_x_offset' => 'setAnchorXOffset',
        'anchor_x_offset_metadata' => 'setAnchorXOffsetMetadata',
        'anchor_y_offset' => 'setAnchorYOffset',
        'anchor_y_offset_metadata' => 'setAnchorYOffsetMetadata',
        'bold' => 'setBold',
        'bold_metadata' => 'setBoldMetadata',
        'caption' => 'setCaption',
        'caption_metadata' => 'setCaptionMetadata',
        'conditional_parent_label' => 'setConditionalParentLabel',
        'conditional_parent_label_metadata' => 'setConditionalParentLabelMetadata',
        'conditional_parent_value' => 'setConditionalParentValue',
        'conditional_parent_value_metadata' => 'setConditionalParentValueMetadata',
        'custom_tab_id' => 'setCustomTabId',
        'custom_tab_id_metadata' => 'setCustomTabIdMetadata',
        'document_id' => 'setDocumentId',
        'document_id_metadata' => 'setDocumentIdMetadata',
        'error_details' => 'setErrorDetails',
        'font' => 'setFont',
        'font_color' => 'setFontColor',
        'font_color_metadata' => 'setFontColorMetadata',
        'font_metadata' => 'setFontMetadata',
        'font_size' => 'setFontSize',
        'font_size_metadata' => 'setFontSizeMetadata',
        'form_order' => 'setFormOrder',
        'form_order_metadata' => 'setFormOrderMetadata',
        'form_page_label' => 'setFormPageLabel',
        'form_page_label_metadata' => 'setFormPageLabelMetadata',
        'form_page_number' => 'setFormPageNumber',
        'form_page_number_metadata' => 'setFormPageNumberMetadata',
        'height' => 'setHeight',
        'height_metadata' => 'setHeightMetadata',
        'italic' => 'setItalic',
        'italic_metadata' => 'setItalicMetadata',
        'locale_policy' => 'setLocalePolicy',
        'merge_field' => 'setMergeField',
        'merge_field_xml' => 'setMergeFieldXml',
        'name' => 'setName',
        'name_metadata' => 'setNameMetadata',
        'page_number' => 'setPageNumber',
        'page_number_metadata' => 'setPageNumberMetadata',
        'recipient_id' => 'setRecipientId',
        'recipient_id_guid' => 'setRecipientIdGuid',
        'recipient_id_guid_metadata' => 'setRecipientIdGuidMetadata',
        'recipient_id_metadata' => 'setRecipientIdMetadata',
        'smart_contract_information' => 'setSmartContractInformation',
        'source' => 'setSource',
        'status' => 'setStatus',
        'status_metadata' => 'setStatusMetadata',
        'tab_group_labels' => 'setTabGroupLabels',
        'tab_group_labels_metadata' => 'setTabGroupLabelsMetadata',
        'tab_id' => 'setTabId',
        'tab_id_metadata' => 'setTabIdMetadata',
        'tab_label' => 'setTabLabel',
        'tab_label_metadata' => 'setTabLabelMetadata',
        'tab_order' => 'setTabOrder',
        'tab_order_metadata' => 'setTabOrderMetadata',
        'tab_type' => 'setTabType',
        'tab_type_metadata' => 'setTabTypeMetadata',
        'template_locked' => 'setTemplateLocked',
        'template_locked_metadata' => 'setTemplateLockedMetadata',
        'template_required' => 'setTemplateRequired',
        'template_required_metadata' => 'setTemplateRequiredMetadata',
        'tooltip' => 'setTooltip',
        'tool_tip_metadata' => 'setToolTipMetadata',
        'underline' => 'setUnderline',
        'underline_metadata' => 'setUnderlineMetadata',
        'value' => 'setValue',
        'value_metadata' => 'setValueMetadata',
        'width' => 'setWidth',
        'width_metadata' => 'setWidthMetadata',
        'x_position' => 'setXPosition',
        'x_position_metadata' => 'setXPositionMetadata',
        'y_position' => 'setYPosition',
        'y_position_metadata' => 'setYPositionMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'anchor_allow_white_space_in_characters' => 'getAnchorAllowWhiteSpaceInCharacters',
        'anchor_allow_white_space_in_characters_metadata' => 'getAnchorAllowWhiteSpaceInCharactersMetadata',
        'anchor_case_sensitive' => 'getAnchorCaseSensitive',
        'anchor_case_sensitive_metadata' => 'getAnchorCaseSensitiveMetadata',
        'anchor_horizontal_alignment' => 'getAnchorHorizontalAlignment',
        'anchor_horizontal_alignment_metadata' => 'getAnchorHorizontalAlignmentMetadata',
        'anchor_ignore_if_not_present' => 'getAnchorIgnoreIfNotPresent',
        'anchor_ignore_if_not_present_metadata' => 'getAnchorIgnoreIfNotPresentMetadata',
        'anchor_match_whole_word' => 'getAnchorMatchWholeWord',
        'anchor_match_whole_word_metadata' => 'getAnchorMatchWholeWordMetadata',
        'anchor_string' => 'getAnchorString',
        'anchor_string_metadata' => 'getAnchorStringMetadata',
        'anchor_tab_processor_version' => 'getAnchorTabProcessorVersion',
        'anchor_tab_processor_version_metadata' => 'getAnchorTabProcessorVersionMetadata',
        'anchor_units' => 'getAnchorUnits',
        'anchor_units_metadata' => 'getAnchorUnitsMetadata',
        'anchor_x_offset' => 'getAnchorXOffset',
        'anchor_x_offset_metadata' => 'getAnchorXOffsetMetadata',
        'anchor_y_offset' => 'getAnchorYOffset',
        'anchor_y_offset_metadata' => 'getAnchorYOffsetMetadata',
        'bold' => 'getBold',
        'bold_metadata' => 'getBoldMetadata',
        'caption' => 'getCaption',
        'caption_metadata' => 'getCaptionMetadata',
        'conditional_parent_label' => 'getConditionalParentLabel',
        'conditional_parent_label_metadata' => 'getConditionalParentLabelMetadata',
        'conditional_parent_value' => 'getConditionalParentValue',
        'conditional_parent_value_metadata' => 'getConditionalParentValueMetadata',
        'custom_tab_id' => 'getCustomTabId',
        'custom_tab_id_metadata' => 'getCustomTabIdMetadata',
        'document_id' => 'getDocumentId',
        'document_id_metadata' => 'getDocumentIdMetadata',
        'error_details' => 'getErrorDetails',
        'font' => 'getFont',
        'font_color' => 'getFontColor',
        'font_color_metadata' => 'getFontColorMetadata',
        'font_metadata' => 'getFontMetadata',
        'font_size' => 'getFontSize',
        'font_size_metadata' => 'getFontSizeMetadata',
        'form_order' => 'getFormOrder',
        'form_order_metadata' => 'getFormOrderMetadata',
        'form_page_label' => 'getFormPageLabel',
        'form_page_label_metadata' => 'getFormPageLabelMetadata',
        'form_page_number' => 'getFormPageNumber',
        'form_page_number_metadata' => 'getFormPageNumberMetadata',
        'height' => 'getHeight',
        'height_metadata' => 'getHeightMetadata',
        'italic' => 'getItalic',
        'italic_metadata' => 'getItalicMetadata',
        'locale_policy' => 'getLocalePolicy',
        'merge_field' => 'getMergeField',
        'merge_field_xml' => 'getMergeFieldXml',
        'name' => 'getName',
        'name_metadata' => 'getNameMetadata',
        'page_number' => 'getPageNumber',
        'page_number_metadata' => 'getPageNumberMetadata',
        'recipient_id' => 'getRecipientId',
        'recipient_id_guid' => 'getRecipientIdGuid',
        'recipient_id_guid_metadata' => 'getRecipientIdGuidMetadata',
        'recipient_id_metadata' => 'getRecipientIdMetadata',
        'smart_contract_information' => 'getSmartContractInformation',
        'source' => 'getSource',
        'status' => 'getStatus',
        'status_metadata' => 'getStatusMetadata',
        'tab_group_labels' => 'getTabGroupLabels',
        'tab_group_labels_metadata' => 'getTabGroupLabelsMetadata',
        'tab_id' => 'getTabId',
        'tab_id_metadata' => 'getTabIdMetadata',
        'tab_label' => 'getTabLabel',
        'tab_label_metadata' => 'getTabLabelMetadata',
        'tab_order' => 'getTabOrder',
        'tab_order_metadata' => 'getTabOrderMetadata',
        'tab_type' => 'getTabType',
        'tab_type_metadata' => 'getTabTypeMetadata',
        'template_locked' => 'getTemplateLocked',
        'template_locked_metadata' => 'getTemplateLockedMetadata',
        'template_required' => 'getTemplateRequired',
        'template_required_metadata' => 'getTemplateRequiredMetadata',
        'tooltip' => 'getTooltip',
        'tool_tip_metadata' => 'getToolTipMetadata',
        'underline' => 'getUnderline',
        'underline_metadata' => 'getUnderlineMetadata',
        'value' => 'getValue',
        'value_metadata' => 'getValueMetadata',
        'width' => 'getWidth',
        'width_metadata' => 'getWidthMetadata',
        'x_position' => 'getXPosition',
        'x_position_metadata' => 'getXPositionMetadata',
        'y_position' => 'getYPosition',
        'y_position_metadata' => 'getYPositionMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['anchor_allow_white_space_in_characters'] = isset($data['anchor_allow_white_space_in_characters']) ? $data['anchor_allow_white_space_in_characters'] : null;
        $this->container['anchor_allow_white_space_in_characters_metadata'] = isset($data['anchor_allow_white_space_in_characters_metadata']) ? $data['anchor_allow_white_space_in_characters_metadata'] : null;
        $this->container['anchor_case_sensitive'] = isset($data['anchor_case_sensitive']) ? $data['anchor_case_sensitive'] : null;
        $this->container['anchor_case_sensitive_metadata'] = isset($data['anchor_case_sensitive_metadata']) ? $data['anchor_case_sensitive_metadata'] : null;
        $this->container['anchor_horizontal_alignment'] = isset($data['anchor_horizontal_alignment']) ? $data['anchor_horizontal_alignment'] : null;
        $this->container['anchor_horizontal_alignment_metadata'] = isset($data['anchor_horizontal_alignment_metadata']) ? $data['anchor_horizontal_alignment_metadata'] : null;
        $this->container['anchor_ignore_if_not_present'] = isset($data['anchor_ignore_if_not_present']) ? $data['anchor_ignore_if_not_present'] : null;
        $this->container['anchor_ignore_if_not_present_metadata'] = isset($data['anchor_ignore_if_not_present_metadata']) ? $data['anchor_ignore_if_not_present_metadata'] : null;
        $this->container['anchor_match_whole_word'] = isset($data['anchor_match_whole_word']) ? $data['anchor_match_whole_word'] : null;
        $this->container['anchor_match_whole_word_metadata'] = isset($data['anchor_match_whole_word_metadata']) ? $data['anchor_match_whole_word_metadata'] : null;
        $this->container['anchor_string'] = isset($data['anchor_string']) ? $data['anchor_string'] : null;
        $this->container['anchor_string_metadata'] = isset($data['anchor_string_metadata']) ? $data['anchor_string_metadata'] : null;
        $this->container['anchor_tab_processor_version'] = isset($data['anchor_tab_processor_version']) ? $data['anchor_tab_processor_version'] : null;
        $this->container['anchor_tab_processor_version_metadata'] = isset($data['anchor_tab_processor_version_metadata']) ? $data['anchor_tab_processor_version_metadata'] : null;
        $this->container['anchor_units'] = isset($data['anchor_units']) ? $data['anchor_units'] : null;
        $this->container['anchor_units_metadata'] = isset($data['anchor_units_metadata']) ? $data['anchor_units_metadata'] : null;
        $this->container['anchor_x_offset'] = isset($data['anchor_x_offset']) ? $data['anchor_x_offset'] : null;
        $this->container['anchor_x_offset_metadata'] = isset($data['anchor_x_offset_metadata']) ? $data['anchor_x_offset_metadata'] : null;
        $this->container['anchor_y_offset'] = isset($data['anchor_y_offset']) ? $data['anchor_y_offset'] : null;
        $this->container['anchor_y_offset_metadata'] = isset($data['anchor_y_offset_metadata']) ? $data['anchor_y_offset_metadata'] : null;
        $this->container['bold'] = isset($data['bold']) ? $data['bold'] : null;
        $this->container['bold_metadata'] = isset($data['bold_metadata']) ? $data['bold_metadata'] : null;
        $this->container['caption'] = isset($data['caption']) ? $data['caption'] : null;
        $this->container['caption_metadata'] = isset($data['caption_metadata']) ? $data['caption_metadata'] : null;
        $this->container['conditional_parent_label'] = isset($data['conditional_parent_label']) ? $data['conditional_parent_label'] : null;
        $this->container['conditional_parent_label_metadata'] = isset($data['conditional_parent_label_metadata']) ? $data['conditional_parent_label_metadata'] : null;
        $this->container['conditional_parent_value'] = isset($data['conditional_parent_value']) ? $data['conditional_parent_value'] : null;
        $this->container['conditional_parent_value_metadata'] = isset($data['conditional_parent_value_metadata']) ? $data['conditional_parent_value_metadata'] : null;
        $this->container['custom_tab_id'] = isset($data['custom_tab_id']) ? $data['custom_tab_id'] : null;
        $this->container['custom_tab_id_metadata'] = isset($data['custom_tab_id_metadata']) ? $data['custom_tab_id_metadata'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['document_id_metadata'] = isset($data['document_id_metadata']) ? $data['document_id_metadata'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['font'] = isset($data['font']) ? $data['font'] : null;
        $this->container['font_color'] = isset($data['font_color']) ? $data['font_color'] : null;
        $this->container['font_color_metadata'] = isset($data['font_color_metadata']) ? $data['font_color_metadata'] : null;
        $this->container['font_metadata'] = isset($data['font_metadata']) ? $data['font_metadata'] : null;
        $this->container['font_size'] = isset($data['font_size']) ? $data['font_size'] : null;
        $this->container['font_size_metadata'] = isset($data['font_size_metadata']) ? $data['font_size_metadata'] : null;
        $this->container['form_order'] = isset($data['form_order']) ? $data['form_order'] : null;
        $this->container['form_order_metadata'] = isset($data['form_order_metadata']) ? $data['form_order_metadata'] : null;
        $this->container['form_page_label'] = isset($data['form_page_label']) ? $data['form_page_label'] : null;
        $this->container['form_page_label_metadata'] = isset($data['form_page_label_metadata']) ? $data['form_page_label_metadata'] : null;
        $this->container['form_page_number'] = isset($data['form_page_number']) ? $data['form_page_number'] : null;
        $this->container['form_page_number_metadata'] = isset($data['form_page_number_metadata']) ? $data['form_page_number_metadata'] : null;
        $this->container['height'] = isset($data['height']) ? $data['height'] : null;
        $this->container['height_metadata'] = isset($data['height_metadata']) ? $data['height_metadata'] : null;
        $this->container['italic'] = isset($data['italic']) ? $data['italic'] : null;
        $this->container['italic_metadata'] = isset($data['italic_metadata']) ? $data['italic_metadata'] : null;
        $this->container['locale_policy'] = isset($data['locale_policy']) ? $data['locale_policy'] : null;
        $this->container['merge_field'] = isset($data['merge_field']) ? $data['merge_field'] : null;
        $this->container['merge_field_xml'] = isset($data['merge_field_xml']) ? $data['merge_field_xml'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['name_metadata'] = isset($data['name_metadata']) ? $data['name_metadata'] : null;
        $this->container['page_number'] = isset($data['page_number']) ? $data['page_number'] : null;
        $this->container['page_number_metadata'] = isset($data['page_number_metadata']) ? $data['page_number_metadata'] : null;
        $this->container['recipient_id'] = isset($data['recipient_id']) ? $data['recipient_id'] : null;
        $this->container['recipient_id_guid'] = isset($data['recipient_id_guid']) ? $data['recipient_id_guid'] : null;
        $this->container['recipient_id_guid_metadata'] = isset($data['recipient_id_guid_metadata']) ? $data['recipient_id_guid_metadata'] : null;
        $this->container['recipient_id_metadata'] = isset($data['recipient_id_metadata']) ? $data['recipient_id_metadata'] : null;
        $this->container['smart_contract_information'] = isset($data['smart_contract_information']) ? $data['smart_contract_information'] : null;
        $this->container['source'] = isset($data['source']) ? $data['source'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_metadata'] = isset($data['status_metadata']) ? $data['status_metadata'] : null;
        $this->container['tab_group_labels'] = isset($data['tab_group_labels']) ? $data['tab_group_labels'] : null;
        $this->container['tab_group_labels_metadata'] = isset($data['tab_group_labels_metadata']) ? $data['tab_group_labels_metadata'] : null;
        $this->container['tab_id'] = isset($data['tab_id']) ? $data['tab_id'] : null;
        $this->container['tab_id_metadata'] = isset($data['tab_id_metadata']) ? $data['tab_id_metadata'] : null;
        $this->container['tab_label'] = isset($data['tab_label']) ? $data['tab_label'] : null;
        $this->container['tab_label_metadata'] = isset($data['tab_label_metadata']) ? $data['tab_label_metadata'] : null;
        $this->container['tab_order'] = isset($data['tab_order']) ? $data['tab_order'] : null;
        $this->container['tab_order_metadata'] = isset($data['tab_order_metadata']) ? $data['tab_order_metadata'] : null;
        $this->container['tab_type'] = isset($data['tab_type']) ? $data['tab_type'] : null;
        $this->container['tab_type_metadata'] = isset($data['tab_type_metadata']) ? $data['tab_type_metadata'] : null;
        $this->container['template_locked'] = isset($data['template_locked']) ? $data['template_locked'] : null;
        $this->container['template_locked_metadata'] = isset($data['template_locked_metadata']) ? $data['template_locked_metadata'] : null;
        $this->container['template_required'] = isset($data['template_required']) ? $data['template_required'] : null;
        $this->container['template_required_metadata'] = isset($data['template_required_metadata']) ? $data['template_required_metadata'] : null;
        $this->container['tooltip'] = isset($data['tooltip']) ? $data['tooltip'] : null;
        $this->container['tool_tip_metadata'] = isset($data['tool_tip_metadata']) ? $data['tool_tip_metadata'] : null;
        $this->container['underline'] = isset($data['underline']) ? $data['underline'] : null;
        $this->container['underline_metadata'] = isset($data['underline_metadata']) ? $data['underline_metadata'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['value_metadata'] = isset($data['value_metadata']) ? $data['value_metadata'] : null;
        $this->container['width'] = isset($data['width']) ? $data['width'] : null;
        $this->container['width_metadata'] = isset($data['width_metadata']) ? $data['width_metadata'] : null;
        $this->container['x_position'] = isset($data['x_position']) ? $data['x_position'] : null;
        $this->container['x_position_metadata'] = isset($data['x_position_metadata']) ? $data['x_position_metadata'] : null;
        $this->container['y_position'] = isset($data['y_position']) ? $data['y_position'] : null;
        $this->container['y_position_metadata'] = isset($data['y_position_metadata']) ? $data['y_position_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets anchor_allow_white_space_in_characters
     *
     * @return ?string
     */
    public function getAnchorAllowWhiteSpaceInCharacters()
    {
        return $this->container['anchor_allow_white_space_in_characters'];
    }

    /**
     * Sets anchor_allow_white_space_in_characters
     *
     * @param ?string $anchor_allow_white_space_in_characters 
     *
     * @return $this
     */
    public function setAnchorAllowWhiteSpaceInCharacters($anchor_allow_white_space_in_characters)
    {
        $this->container['anchor_allow_white_space_in_characters'] = $anchor_allow_white_space_in_characters;

        return $this;
    }

    /**
     * Gets anchor_allow_white_space_in_characters_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorAllowWhiteSpaceInCharactersMetadata()
    {
        return $this->container['anchor_allow_white_space_in_characters_metadata'];
    }

    /**
     * Sets anchor_allow_white_space_in_characters_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_allow_white_space_in_characters_metadata Metadata that indicates whether the `anchorAllowWhiteSpaceInCharacters` property is editable.
     *
     * @return $this
     */
    public function setAnchorAllowWhiteSpaceInCharactersMetadata($anchor_allow_white_space_in_characters_metadata)
    {
        $this->container['anchor_allow_white_space_in_characters_metadata'] = $anchor_allow_white_space_in_characters_metadata;

        return $this;
    }

    /**
     * Gets anchor_case_sensitive
     *
     * @return ?string
     */
    public function getAnchorCaseSensitive()
    {
        return $this->container['anchor_case_sensitive'];
    }

    /**
     * Sets anchor_case_sensitive
     *
     * @param ?string $anchor_case_sensitive When set to **true**, the anchor string does not consider case when matching strings in the document. The default value is **true**.
     *
     * @return $this
     */
    public function setAnchorCaseSensitive($anchor_case_sensitive)
    {
        $this->container['anchor_case_sensitive'] = $anchor_case_sensitive;

        return $this;
    }

    /**
     * Gets anchor_case_sensitive_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorCaseSensitiveMetadata()
    {
        return $this->container['anchor_case_sensitive_metadata'];
    }

    /**
     * Sets anchor_case_sensitive_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_case_sensitive_metadata Metadata that indicates whether the `anchorCaseSensitive` property is editable.
     *
     * @return $this
     */
    public function setAnchorCaseSensitiveMetadata($anchor_case_sensitive_metadata)
    {
        $this->container['anchor_case_sensitive_metadata'] = $anchor_case_sensitive_metadata;

        return $this;
    }

    /**
     * Gets anchor_horizontal_alignment
     *
     * @return ?string
     */
    public function getAnchorHorizontalAlignment()
    {
        return $this->container['anchor_horizontal_alignment'];
    }

    /**
     * Sets anchor_horizontal_alignment
     *
     * @param ?string $anchor_horizontal_alignment Specifies the alignment of anchor tabs with anchor strings. Possible values are **left** or **right**. The default value is **left**.
     *
     * @return $this
     */
    public function setAnchorHorizontalAlignment($anchor_horizontal_alignment)
    {
        $this->container['anchor_horizontal_alignment'] = $anchor_horizontal_alignment;

        return $this;
    }

    /**
     * Gets anchor_horizontal_alignment_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorHorizontalAlignmentMetadata()
    {
        return $this->container['anchor_horizontal_alignment_metadata'];
    }

    /**
     * Sets anchor_horizontal_alignment_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_horizontal_alignment_metadata Metadata that indicates whether the `anchorHorizontalAlignment` property is editable.
     *
     * @return $this
     */
    public function setAnchorHorizontalAlignmentMetadata($anchor_horizontal_alignment_metadata)
    {
        $this->container['anchor_horizontal_alignment_metadata'] = $anchor_horizontal_alignment_metadata;

        return $this;
    }

    /**
     * Gets anchor_ignore_if_not_present
     *
     * @return ?string
     */
    public function getAnchorIgnoreIfNotPresent()
    {
        return $this->container['anchor_ignore_if_not_present'];
    }

    /**
     * Sets anchor_ignore_if_not_present
     *
     * @param ?string $anchor_ignore_if_not_present When set to **true**, this tab is ignored if anchorString is not found in the document.
     *
     * @return $this
     */
    public function setAnchorIgnoreIfNotPresent($anchor_ignore_if_not_present)
    {
        $this->container['anchor_ignore_if_not_present'] = $anchor_ignore_if_not_present;

        return $this;
    }

    /**
     * Gets anchor_ignore_if_not_present_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorIgnoreIfNotPresentMetadata()
    {
        return $this->container['anchor_ignore_if_not_present_metadata'];
    }

    /**
     * Sets anchor_ignore_if_not_present_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_ignore_if_not_present_metadata Metadata that indicates whether the `anchorIgnoreIfNotPresent` property is editable.
     *
     * @return $this
     */
    public function setAnchorIgnoreIfNotPresentMetadata($anchor_ignore_if_not_present_metadata)
    {
        $this->container['anchor_ignore_if_not_present_metadata'] = $anchor_ignore_if_not_present_metadata;

        return $this;
    }

    /**
     * Gets anchor_match_whole_word
     *
     * @return ?string
     */
    public function getAnchorMatchWholeWord()
    {
        return $this->container['anchor_match_whole_word'];
    }

    /**
     * Sets anchor_match_whole_word
     *
     * @param ?string $anchor_match_whole_word When set to **true**, the anchor string in this tab matches whole words only (strings embedded in other strings are ignored.) The default value is **true**.
     *
     * @return $this
     */
    public function setAnchorMatchWholeWord($anchor_match_whole_word)
    {
        $this->container['anchor_match_whole_word'] = $anchor_match_whole_word;

        return $this;
    }

    /**
     * Gets anchor_match_whole_word_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorMatchWholeWordMetadata()
    {
        return $this->container['anchor_match_whole_word_metadata'];
    }

    /**
     * Sets anchor_match_whole_word_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_match_whole_word_metadata Metadata that indicates whether the `anchorMatchWholeWord` property is editable.
     *
     * @return $this
     */
    public function setAnchorMatchWholeWordMetadata($anchor_match_whole_word_metadata)
    {
        $this->container['anchor_match_whole_word_metadata'] = $anchor_match_whole_word_metadata;

        return $this;
    }

    /**
     * Gets anchor_string
     *
     * @return ?string
     */
    public function getAnchorString()
    {
        return $this->container['anchor_string'];
    }

    /**
     * Sets anchor_string
     *
     * @param ?string $anchor_string Anchor text information for a radio button.
     *
     * @return $this
     */
    public function setAnchorString($anchor_string)
    {
        $this->container['anchor_string'] = $anchor_string;

        return $this;
    }

    /**
     * Gets anchor_string_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorStringMetadata()
    {
        return $this->container['anchor_string_metadata'];
    }

    /**
     * Sets anchor_string_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_string_metadata Metadata that indicates whether the `anchorString` property is editable.
     *
     * @return $this
     */
    public function setAnchorStringMetadata($anchor_string_metadata)
    {
        $this->container['anchor_string_metadata'] = $anchor_string_metadata;

        return $this;
    }

    /**
     * Gets anchor_tab_processor_version
     *
     * @return ?string
     */
    public function getAnchorTabProcessorVersion()
    {
        return $this->container['anchor_tab_processor_version'];
    }

    /**
     * Sets anchor_tab_processor_version
     *
     * @param ?string $anchor_tab_processor_version 
     *
     * @return $this
     */
    public function setAnchorTabProcessorVersion($anchor_tab_processor_version)
    {
        $this->container['anchor_tab_processor_version'] = $anchor_tab_processor_version;

        return $this;
    }

    /**
     * Gets anchor_tab_processor_version_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorTabProcessorVersionMetadata()
    {
        return $this->container['anchor_tab_processor_version_metadata'];
    }

    /**
     * Sets anchor_tab_processor_version_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_tab_processor_version_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setAnchorTabProcessorVersionMetadata($anchor_tab_processor_version_metadata)
    {
        $this->container['anchor_tab_processor_version_metadata'] = $anchor_tab_processor_version_metadata;

        return $this;
    }

    /**
     * Gets anchor_units
     *
     * @return ?string
     */
    public function getAnchorUnits()
    {
        return $this->container['anchor_units'];
    }

    /**
     * Sets anchor_units
     *
     * @param ?string $anchor_units Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.
     *
     * @return $this
     */
    public function setAnchorUnits($anchor_units)
    {
        $this->container['anchor_units'] = $anchor_units;

        return $this;
    }

    /**
     * Gets anchor_units_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorUnitsMetadata()
    {
        return $this->container['anchor_units_metadata'];
    }

    /**
     * Sets anchor_units_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_units_metadata Metadata that indicates whether the `anchorUnits` property is editable.
     *
     * @return $this
     */
    public function setAnchorUnitsMetadata($anchor_units_metadata)
    {
        $this->container['anchor_units_metadata'] = $anchor_units_metadata;

        return $this;
    }

    /**
     * Gets anchor_x_offset
     *
     * @return ?string
     */
    public function getAnchorXOffset()
    {
        return $this->container['anchor_x_offset'];
    }

    /**
     * Sets anchor_x_offset
     *
     * @param ?string $anchor_x_offset Specifies the X axis location of the tab, in anchorUnits, relative to the anchorString.
     *
     * @return $this
     */
    public function setAnchorXOffset($anchor_x_offset)
    {
        $this->container['anchor_x_offset'] = $anchor_x_offset;

        return $this;
    }

    /**
     * Gets anchor_x_offset_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorXOffsetMetadata()
    {
        return $this->container['anchor_x_offset_metadata'];
    }

    /**
     * Sets anchor_x_offset_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_x_offset_metadata Metadata that indicates whether the `anchorXOffset` property is editable.
     *
     * @return $this
     */
    public function setAnchorXOffsetMetadata($anchor_x_offset_metadata)
    {
        $this->container['anchor_x_offset_metadata'] = $anchor_x_offset_metadata;

        return $this;
    }

    /**
     * Gets anchor_y_offset
     *
     * @return ?string
     */
    public function getAnchorYOffset()
    {
        return $this->container['anchor_y_offset'];
    }

    /**
     * Sets anchor_y_offset
     *
     * @param ?string $anchor_y_offset Specifies the Y axis location of the tab, in anchorUnits, relative to the anchorString.
     *
     * @return $this
     */
    public function setAnchorYOffset($anchor_y_offset)
    {
        $this->container['anchor_y_offset'] = $anchor_y_offset;

        return $this;
    }

    /**
     * Gets anchor_y_offset_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAnchorYOffsetMetadata()
    {
        return $this->container['anchor_y_offset_metadata'];
    }

    /**
     * Sets anchor_y_offset_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $anchor_y_offset_metadata Metadata that indicates whether the `anchorYOffset` property is editable.
     *
     * @return $this
     */
    public function setAnchorYOffsetMetadata($anchor_y_offset_metadata)
    {
        $this->container['anchor_y_offset_metadata'] = $anchor_y_offset_metadata;

        return $this;
    }

    /**
     * Gets bold
     *
     * @return ?string
     */
    public function getBold()
    {
        return $this->container['bold'];
    }

    /**
     * Sets bold
     *
     * @param ?string $bold When set to **true**, the information in the tab is bold.
     *
     * @return $this
     */
    public function setBold($bold)
    {
        $this->container['bold'] = $bold;

        return $this;
    }

    /**
     * Gets bold_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getBoldMetadata()
    {
        return $this->container['bold_metadata'];
    }

    /**
     * Sets bold_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $bold_metadata Metadata that indicates whether the `bold` property is editable.
     *
     * @return $this
     */
    public function setBoldMetadata($bold_metadata)
    {
        $this->container['bold_metadata'] = $bold_metadata;

        return $this;
    }

    /**
     * Gets caption
     *
     * @return ?string
     */
    public function getCaption()
    {
        return $this->container['caption'];
    }

    /**
     * Sets caption
     *
     * @param ?string $caption 
     *
     * @return $this
     */
    public function setCaption($caption)
    {
        $this->container['caption'] = $caption;

        return $this;
    }

    /**
     * Gets caption_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getCaptionMetadata()
    {
        return $this->container['caption_metadata'];
    }

    /**
     * Sets caption_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $caption_metadata 
     *
     * @return $this
     */
    public function setCaptionMetadata($caption_metadata)
    {
        $this->container['caption_metadata'] = $caption_metadata;

        return $this;
    }

    /**
     * Gets conditional_parent_label
     *
     * @return ?string
     */
    public function getConditionalParentLabel()
    {
        return $this->container['conditional_parent_label'];
    }

    /**
     * Sets conditional_parent_label
     *
     * @param ?string $conditional_parent_label For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.
     *
     * @return $this
     */
    public function setConditionalParentLabel($conditional_parent_label)
    {
        $this->container['conditional_parent_label'] = $conditional_parent_label;

        return $this;
    }

    /**
     * Gets conditional_parent_label_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getConditionalParentLabelMetadata()
    {
        return $this->container['conditional_parent_label_metadata'];
    }

    /**
     * Sets conditional_parent_label_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $conditional_parent_label_metadata Metadata that indicates whether the `conditionalParentLabel` property is editable.
     *
     * @return $this
     */
    public function setConditionalParentLabelMetadata($conditional_parent_label_metadata)
    {
        $this->container['conditional_parent_label_metadata'] = $conditional_parent_label_metadata;

        return $this;
    }

    /**
     * Gets conditional_parent_value
     *
     * @return ?string
     */
    public function getConditionalParentValue()
    {
        return $this->container['conditional_parent_value'];
    }

    /**
     * Sets conditional_parent_value
     *
     * @param ?string $conditional_parent_value For conditional fields, this is the value of the parent tab that controls the tab's visibility.  If the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active.
     *
     * @return $this
     */
    public function setConditionalParentValue($conditional_parent_value)
    {
        $this->container['conditional_parent_value'] = $conditional_parent_value;

        return $this;
    }

    /**
     * Gets conditional_parent_value_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getConditionalParentValueMetadata()
    {
        return $this->container['conditional_parent_value_metadata'];
    }

    /**
     * Sets conditional_parent_value_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $conditional_parent_value_metadata Metadata that indicates whether the `conditionalParentValue` property is editable.
     *
     * @return $this
     */
    public function setConditionalParentValueMetadata($conditional_parent_value_metadata)
    {
        $this->container['conditional_parent_value_metadata'] = $conditional_parent_value_metadata;

        return $this;
    }

    /**
     * Gets custom_tab_id
     *
     * @return ?string
     */
    public function getCustomTabId()
    {
        return $this->container['custom_tab_id'];
    }

    /**
     * Sets custom_tab_id
     *
     * @param ?string $custom_tab_id The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.
     *
     * @return $this
     */
    public function setCustomTabId($custom_tab_id)
    {
        $this->container['custom_tab_id'] = $custom_tab_id;

        return $this;
    }

    /**
     * Gets custom_tab_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getCustomTabIdMetadata()
    {
        return $this->container['custom_tab_id_metadata'];
    }

    /**
     * Sets custom_tab_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $custom_tab_id_metadata Metadata that indicates whether the `customTabId` property is editable.
     *
     * @return $this
     */
    public function setCustomTabIdMetadata($custom_tab_id_metadata)
    {
        $this->container['custom_tab_id_metadata'] = $custom_tab_id_metadata;

        return $this;
    }

    /**
     * Gets document_id
     *
     * @return ?string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     *
     * @param ?string $document_id Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.
     *
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets document_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getDocumentIdMetadata()
    {
        return $this->container['document_id_metadata'];
    }

    /**
     * Sets document_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $document_id_metadata Metadata that indicates whether the `documentId` property is editable.
     *
     * @return $this
     */
    public function setDocumentIdMetadata($document_id_metadata)
    {
        $this->container['document_id_metadata'] = $document_id_metadata;

        return $this;
    }

    /**
     * Gets error_details
     *
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets font
     *
     * @return ?string
     */
    public function getFont()
    {
        return $this->container['font'];
    }

    /**
     * Sets font
     *
     * @param ?string $font The font to be used for the tab value. Supported Fonts: Arial, Arial, ArialNarrow, Calibri, CourierNew, Garamond, Georgia, Helvetica,   LucidaConsole, Tahoma, TimesNewRoman, Trebuchet, Verdana, MSGothic, MSMincho, Default.
     *
     * @return $this
     */
    public function setFont($font)
    {
        $this->container['font'] = $font;

        return $this;
    }

    /**
     * Gets font_color
     *
     * @return ?string
     */
    public function getFontColor()
    {
        return $this->container['font_color'];
    }

    /**
     * Sets font_color
     *
     * @param ?string $font_color The font color used for the information in the tab.  Possible values are: Black, BrightBlue, BrightRed, DarkGreen, DarkRed, Gold, Green, NavyBlue, Purple, or White.
     *
     * @return $this
     */
    public function setFontColor($font_color)
    {
        $this->container['font_color'] = $font_color;

        return $this;
    }

    /**
     * Gets font_color_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontColorMetadata()
    {
        return $this->container['font_color_metadata'];
    }

    /**
     * Sets font_color_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_color_metadata Metadata that indicates whether the `fontColor` property is editable.
     *
     * @return $this
     */
    public function setFontColorMetadata($font_color_metadata)
    {
        $this->container['font_color_metadata'] = $font_color_metadata;

        return $this;
    }

    /**
     * Gets font_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontMetadata()
    {
        return $this->container['font_metadata'];
    }

    /**
     * Sets font_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_metadata Metadata that indicates whether the `font` property is editable.
     *
     * @return $this
     */
    public function setFontMetadata($font_metadata)
    {
        $this->container['font_metadata'] = $font_metadata;

        return $this;
    }

    /**
     * Gets font_size
     *
     * @return ?string
     */
    public function getFontSize()
    {
        return $this->container['font_size'];
    }

    /**
     * Sets font_size
     *
     * @param ?string $font_size The font size used for the information in the tab.  Possible values are: Size7, Size8, Size9, Size10, Size11, Size12, Size14, Size16, Size18, Size20, Size22, Size24, Size26, Size28, Size36, Size48, or Size72.
     *
     * @return $this
     */
    public function setFontSize($font_size)
    {
        $this->container['font_size'] = $font_size;

        return $this;
    }

    /**
     * Gets font_size_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFontSizeMetadata()
    {
        return $this->container['font_size_metadata'];
    }

    /**
     * Sets font_size_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $font_size_metadata Metadata that indicates whether the `fontSize` property is editable.
     *
     * @return $this
     */
    public function setFontSizeMetadata($font_size_metadata)
    {
        $this->container['font_size_metadata'] = $font_size_metadata;

        return $this;
    }

    /**
     * Gets form_order
     *
     * @return ?string
     */
    public function getFormOrder()
    {
        return $this->container['form_order'];
    }

    /**
     * Sets form_order
     *
     * @param ?string $form_order 
     *
     * @return $this
     */
    public function setFormOrder($form_order)
    {
        $this->container['form_order'] = $form_order;

        return $this;
    }

    /**
     * Gets form_order_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFormOrderMetadata()
    {
        return $this->container['form_order_metadata'];
    }

    /**
     * Sets form_order_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $form_order_metadata Metadata that indicates whether the `formOrder` property is editable.
     *
     * @return $this
     */
    public function setFormOrderMetadata($form_order_metadata)
    {
        $this->container['form_order_metadata'] = $form_order_metadata;

        return $this;
    }

    /**
     * Gets form_page_label
     *
     * @return ?string
     */
    public function getFormPageLabel()
    {
        return $this->container['form_page_label'];
    }

    /**
     * Sets form_page_label
     *
     * @param ?string $form_page_label 
     *
     * @return $this
     */
    public function setFormPageLabel($form_page_label)
    {
        $this->container['form_page_label'] = $form_page_label;

        return $this;
    }

    /**
     * Gets form_page_label_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFormPageLabelMetadata()
    {
        return $this->container['form_page_label_metadata'];
    }

    /**
     * Sets form_page_label_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $form_page_label_metadata Metadata that indicates whether the `formPageLabel` property is editable.
     *
     * @return $this
     */
    public function setFormPageLabelMetadata($form_page_label_metadata)
    {
        $this->container['form_page_label_metadata'] = $form_page_label_metadata;

        return $this;
    }

    /**
     * Gets form_page_number
     *
     * @return ?string
     */
    public function getFormPageNumber()
    {
        return $this->container['form_page_number'];
    }

    /**
     * Sets form_page_number
     *
     * @param ?string $form_page_number 
     *
     * @return $this
     */
    public function setFormPageNumber($form_page_number)
    {
        $this->container['form_page_number'] = $form_page_number;

        return $this;
    }

    /**
     * Gets form_page_number_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFormPageNumberMetadata()
    {
        return $this->container['form_page_number_metadata'];
    }

    /**
     * Sets form_page_number_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $form_page_number_metadata Metadata that indicates whether the `fromPageNumber` property is editable.
     *
     * @return $this
     */
    public function setFormPageNumberMetadata($form_page_number_metadata)
    {
        $this->container['form_page_number_metadata'] = $form_page_number_metadata;

        return $this;
    }

    /**
     * Gets height
     *
     * @return ?string
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param ?string $height Height of the tab in pixels.
     *
     * @return $this
     */
    public function setHeight($height)
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets height_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getHeightMetadata()
    {
        return $this->container['height_metadata'];
    }

    /**
     * Sets height_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $height_metadata Metadata that indicates whether the `height` property is editable.
     *
     * @return $this
     */
    public function setHeightMetadata($height_metadata)
    {
        $this->container['height_metadata'] = $height_metadata;

        return $this;
    }

    /**
     * Gets italic
     *
     * @return ?string
     */
    public function getItalic()
    {
        return $this->container['italic'];
    }

    /**
     * Sets italic
     *
     * @param ?string $italic When set to **true**, the information in the tab is italic.
     *
     * @return $this
     */
    public function setItalic($italic)
    {
        $this->container['italic'] = $italic;

        return $this;
    }

    /**
     * Gets italic_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getItalicMetadata()
    {
        return $this->container['italic_metadata'];
    }

    /**
     * Sets italic_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $italic_metadata Metadata that indicates whether the `italic` property is editable.
     *
     * @return $this
     */
    public function setItalicMetadata($italic_metadata)
    {
        $this->container['italic_metadata'] = $italic_metadata;

        return $this;
    }

    /**
     * Gets locale_policy
     *
     * @return \DocuSign\eSign\Model\LocalePolicyTab
     */
    public function getLocalePolicy()
    {
        return $this->container['locale_policy'];
    }

    /**
     * Sets locale_policy
     *
     * @param \DocuSign\eSign\Model\LocalePolicyTab $locale_policy Reserved for DocuSign.
     *
     * @return $this
     */
    public function setLocalePolicy($locale_policy)
    {
        $this->container['locale_policy'] = $locale_policy;

        return $this;
    }

    /**
     * Gets merge_field
     *
     * @return \DocuSign\eSign\Model\MergeField
     */
    public function getMergeField()
    {
        return $this->container['merge_field'];
    }

    /**
     * Sets merge_field
     *
     * @param \DocuSign\eSign\Model\MergeField $merge_field Contains the information necessary to map the tab to a field in SalesForce.
     *
     * @return $this
     */
    public function setMergeField($merge_field)
    {
        $this->container['merge_field'] = $merge_field;

        return $this;
    }

    /**
     * Gets merge_field_xml
     *
     * @return ?string
     */
    public function getMergeFieldXml()
    {
        return $this->container['merge_field_xml'];
    }

    /**
     * Sets merge_field_xml
     *
     * @param ?string $merge_field_xml 
     *
     * @return $this
     */
    public function setMergeFieldXml($merge_field_xml)
    {
        $this->container['merge_field_xml'] = $merge_field_xml;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getNameMetadata()
    {
        return $this->container['name_metadata'];
    }

    /**
     * Sets name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $name_metadata Metadata that indicates whether the `name` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setNameMetadata($name_metadata)
    {
        $this->container['name_metadata'] = $name_metadata;

        return $this;
    }

    /**
     * Gets page_number
     *
     * @return ?string
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     *
     * @param ?string $page_number Specifies the page number on which the tab is located.
     *
     * @return $this
     */
    public function setPageNumber($page_number)
    {
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets page_number_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getPageNumberMetadata()
    {
        return $this->container['page_number_metadata'];
    }

    /**
     * Sets page_number_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $page_number_metadata Metadata that indicates whether the `pageNumber` property is editable.
     *
     * @return $this
     */
    public function setPageNumberMetadata($page_number_metadata)
    {
        $this->container['page_number_metadata'] = $page_number_metadata;

        return $this;
    }

    /**
     * Gets recipient_id
     *
     * @return ?string
     */
    public function getRecipientId()
    {
        return $this->container['recipient_id'];
    }

    /**
     * Sets recipient_id
     *
     * @param ?string $recipient_id Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.
     *
     * @return $this
     */
    public function setRecipientId($recipient_id)
    {
        $this->container['recipient_id'] = $recipient_id;

        return $this;
    }

    /**
     * Gets recipient_id_guid
     *
     * @return ?string
     */
    public function getRecipientIdGuid()
    {
        return $this->container['recipient_id_guid'];
    }

    /**
     * Sets recipient_id_guid
     *
     * @param ?string $recipient_id_guid 
     *
     * @return $this
     */
    public function setRecipientIdGuid($recipient_id_guid)
    {
        $this->container['recipient_id_guid'] = $recipient_id_guid;

        return $this;
    }

    /**
     * Gets recipient_id_guid_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRecipientIdGuidMetadata()
    {
        return $this->container['recipient_id_guid_metadata'];
    }

    /**
     * Sets recipient_id_guid_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $recipient_id_guid_metadata Metadata that indicates whether the `recipientIdGuid` property is editable.
     *
     * @return $this
     */
    public function setRecipientIdGuidMetadata($recipient_id_guid_metadata)
    {
        $this->container['recipient_id_guid_metadata'] = $recipient_id_guid_metadata;

        return $this;
    }

    /**
     * Gets recipient_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRecipientIdMetadata()
    {
        return $this->container['recipient_id_metadata'];
    }

    /**
     * Sets recipient_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $recipient_id_metadata Metadata that indicates whether the `recipientId` property is editable.
     *
     * @return $this
     */
    public function setRecipientIdMetadata($recipient_id_metadata)
    {
        $this->container['recipient_id_metadata'] = $recipient_id_metadata;

        return $this;
    }

    /**
     * Gets smart_contract_information
     *
     * @return \DocuSign\eSign\Model\SmartContractInformation
     */
    public function getSmartContractInformation()
    {
        return $this->container['smart_contract_information'];
    }

    /**
     * Sets smart_contract_information
     *
     * @param \DocuSign\eSign\Model\SmartContractInformation $smart_contract_information Reserved for DocuSign.
     *
     * @return $this
     */
    public function setSmartContractInformation($smart_contract_information)
    {
        $this->container['smart_contract_information'] = $smart_contract_information;

        return $this;
    }

    /**
     * Gets source
     *
     * @return ?string
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param ?string $source 
     *
     * @return $this
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getStatusMetadata()
    {
        return $this->container['status_metadata'];
    }

    /**
     * Sets status_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $status_metadata Metadata that indicates whether the `status` property is editable.
     *
     * @return $this
     */
    public function setStatusMetadata($status_metadata)
    {
        $this->container['status_metadata'] = $status_metadata;

        return $this;
    }

    /**
     * Gets tab_group_labels
     *
     * @return ?string[]
     */
    public function getTabGroupLabels()
    {
        return $this->container['tab_group_labels'];
    }

    /**
     * Sets tab_group_labels
     *
     * @param ?string[] $tab_group_labels 
     *
     * @return $this
     */
    public function setTabGroupLabels($tab_group_labels)
    {
        $this->container['tab_group_labels'] = $tab_group_labels;

        return $this;
    }

    /**
     * Gets tab_group_labels_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabGroupLabelsMetadata()
    {
        return $this->container['tab_group_labels_metadata'];
    }

    /**
     * Sets tab_group_labels_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_group_labels_metadata Metadata that indicates whether the `tabGroupLabels` property is editable.
     *
     * @return $this
     */
    public function setTabGroupLabelsMetadata($tab_group_labels_metadata)
    {
        $this->container['tab_group_labels_metadata'] = $tab_group_labels_metadata;

        return $this;
    }

    /**
     * Gets tab_id
     *
     * @return ?string
     */
    public function getTabId()
    {
        return $this->container['tab_id'];
    }

    /**
     * Sets tab_id
     *
     * @param ?string $tab_id The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call].
     *
     * @return $this
     */
    public function setTabId($tab_id)
    {
        $this->container['tab_id'] = $tab_id;

        return $this;
    }

    /**
     * Gets tab_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabIdMetadata()
    {
        return $this->container['tab_id_metadata'];
    }

    /**
     * Sets tab_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_id_metadata Metadata that indicates whether the `tabId` property is editable.
     *
     * @return $this
     */
    public function setTabIdMetadata($tab_id_metadata)
    {
        $this->container['tab_id_metadata'] = $tab_id_metadata;

        return $this;
    }

    /**
     * Gets tab_label
     *
     * @return ?string
     */
    public function getTabLabel()
    {
        return $this->container['tab_label'];
    }

    /**
     * Sets tab_label
     *
     * @param ?string $tab_label The label string associated with the tab.
     *
     * @return $this
     */
    public function setTabLabel($tab_label)
    {
        $this->container['tab_label'] = $tab_label;

        return $this;
    }

    /**
     * Gets tab_label_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabLabelMetadata()
    {
        return $this->container['tab_label_metadata'];
    }

    /**
     * Sets tab_label_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_label_metadata Metadata that indicates whether the `tabLabel` property is editable.
     *
     * @return $this
     */
    public function setTabLabelMetadata($tab_label_metadata)
    {
        $this->container['tab_label_metadata'] = $tab_label_metadata;

        return $this;
    }

    /**
     * Gets tab_order
     *
     * @return ?string
     */
    public function getTabOrder()
    {
        return $this->container['tab_order'];
    }

    /**
     * Sets tab_order
     *
     * @param ?string $tab_order 
     *
     * @return $this
     */
    public function setTabOrder($tab_order)
    {
        $this->container['tab_order'] = $tab_order;

        return $this;
    }

    /**
     * Gets tab_order_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabOrderMetadata()
    {
        return $this->container['tab_order_metadata'];
    }

    /**
     * Sets tab_order_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_order_metadata Metadata that indicates whether the `tabOrder` property is editable.
     *
     * @return $this
     */
    public function setTabOrderMetadata($tab_order_metadata)
    {
        $this->container['tab_order_metadata'] = $tab_order_metadata;

        return $this;
    }

    /**
     * Gets tab_type
     *
     * @return ?string
     */
    public function getTabType()
    {
        return $this->container['tab_type'];
    }

    /**
     * Sets tab_type
     *
     * @param ?string $tab_type 
     *
     * @return $this
     */
    public function setTabType($tab_type)
    {
        $this->container['tab_type'] = $tab_type;

        return $this;
    }

    /**
     * Gets tab_type_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTabTypeMetadata()
    {
        return $this->container['tab_type_metadata'];
    }

    /**
     * Sets tab_type_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tab_type_metadata Metadata that indicates whether the `tabType` property is editable.
     *
     * @return $this
     */
    public function setTabTypeMetadata($tab_type_metadata)
    {
        $this->container['tab_type_metadata'] = $tab_type_metadata;

        return $this;
    }

    /**
     * Gets template_locked
     *
     * @return ?string
     */
    public function getTemplateLocked()
    {
        return $this->container['template_locked'];
    }

    /**
     * Sets template_locked
     *
     * @param ?string $template_locked When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.
     *
     * @return $this
     */
    public function setTemplateLocked($template_locked)
    {
        $this->container['template_locked'] = $template_locked;

        return $this;
    }

    /**
     * Gets template_locked_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTemplateLockedMetadata()
    {
        return $this->container['template_locked_metadata'];
    }

    /**
     * Sets template_locked_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $template_locked_metadata Metadata that indicates whether the `templateLocked` property is editable.
     *
     * @return $this
     */
    public function setTemplateLockedMetadata($template_locked_metadata)
    {
        $this->container['template_locked_metadata'] = $template_locked_metadata;

        return $this;
    }

    /**
     * Gets template_required
     *
     * @return ?string
     */
    public function getTemplateRequired()
    {
        return $this->container['template_required'];
    }

    /**
     * Sets template_required
     *
     * @param ?string $template_required When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.
     *
     * @return $this
     */
    public function setTemplateRequired($template_required)
    {
        $this->container['template_required'] = $template_required;

        return $this;
    }

    /**
     * Gets template_required_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTemplateRequiredMetadata()
    {
        return $this->container['template_required_metadata'];
    }

    /**
     * Sets template_required_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $template_required_metadata Metadata that indicates whether the `templateRequired` property is editable.
     *
     * @return $this
     */
    public function setTemplateRequiredMetadata($template_required_metadata)
    {
        $this->container['template_required_metadata'] = $template_required_metadata;

        return $this;
    }

    /**
     * Gets tooltip
     *
     * @return ?string
     */
    public function getTooltip()
    {
        return $this->container['tooltip'];
    }

    /**
     * Sets tooltip
     *
     * @param ?string $tooltip 
     *
     * @return $this
     */
    public function setTooltip($tooltip)
    {
        $this->container['tooltip'] = $tooltip;

        return $this;
    }

    /**
     * Gets tool_tip_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getToolTipMetadata()
    {
        return $this->container['tool_tip_metadata'];
    }

    /**
     * Sets tool_tip_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $tool_tip_metadata Metadata that indicates whether the `toolTip` property is editable.
     *
     * @return $this
     */
    public function setToolTipMetadata($tool_tip_metadata)
    {
        $this->container['tool_tip_metadata'] = $tool_tip_metadata;

        return $this;
    }

    /**
     * Gets underline
     *
     * @return ?string
     */
    public function getUnderline()
    {
        return $this->container['underline'];
    }

    /**
     * Sets underline
     *
     * @param ?string $underline When set to **true**, the information in the tab is underlined.
     *
     * @return $this
     */
    public function setUnderline($underline)
    {
        $this->container['underline'] = $underline;

        return $this;
    }

    /**
     * Gets underline_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getUnderlineMetadata()
    {
        return $this->container['underline_metadata'];
    }

    /**
     * Sets underline_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $underline_metadata Metadata that indicates whether the `underline` property is editable.
     *
     * @return $this
     */
    public function setUnderlineMetadata($underline_metadata)
    {
        $this->container['underline_metadata'] = $underline_metadata;

        return $this;
    }

    /**
     * Gets value
     *
     * @return ?string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param ?string $value Specifies the value of the tab.
     *
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets value_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getValueMetadata()
    {
        return $this->container['value_metadata'];
    }

    /**
     * Sets value_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $value_metadata Metadata that indicates whether the `value` property is editable.
     *
     * @return $this
     */
    public function setValueMetadata($value_metadata)
    {
        $this->container['value_metadata'] = $value_metadata;

        return $this;
    }

    /**
     * Gets width
     *
     * @return ?string
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param ?string $width Width of the tab in pixels.
     *
     * @return $this
     */
    public function setWidth($width)
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets width_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getWidthMetadata()
    {
        return $this->container['width_metadata'];
    }

    /**
     * Sets width_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $width_metadata Metadata that indicates whether the `width` property is editable.
     *
     * @return $this
     */
    public function setWidthMetadata($width_metadata)
    {
        $this->container['width_metadata'] = $width_metadata;

        return $this;
    }

    /**
     * Gets x_position
     *
     * @return ?string
     */
    public function getXPosition()
    {
        return $this->container['x_position'];
    }

    /**
     * Sets x_position
     *
     * @param ?string $x_position This indicates the horizontal offset of the object on the page. DocuSign uses 72 DPI when determining position.
     *
     * @return $this
     */
    public function setXPosition($x_position)
    {
        $this->container['x_position'] = $x_position;

        return $this;
    }

    /**
     * Gets x_position_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getXPositionMetadata()
    {
        return $this->container['x_position_metadata'];
    }

    /**
     * Sets x_position_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $x_position_metadata Metadata that indicates whether the `xPosition` property is editable.
     *
     * @return $this
     */
    public function setXPositionMetadata($x_position_metadata)
    {
        $this->container['x_position_metadata'] = $x_position_metadata;

        return $this;
    }

    /**
     * Gets y_position
     *
     * @return ?string
     */
    public function getYPosition()
    {
        return $this->container['y_position'];
    }

    /**
     * Sets y_position
     *
     * @param ?string $y_position This indicates the vertical offset of the object on the page. DocuSign uses 72 DPI when determining position.
     *
     * @return $this
     */
    public function setYPosition($y_position)
    {
        $this->container['y_position'] = $y_position;

        return $this;
    }

    /**
     * Gets y_position_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getYPositionMetadata()
    {
        return $this->container['y_position_metadata'];
    }

    /**
     * Sets y_position_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $y_position_metadata Metadata that indicates whether the `yPosition` property is editable.
     *
     * @return $this
     */
    public function setYPositionMetadata($y_position_metadata)
    {
        $this->container['y_position_metadata'] = $y_position_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

