<?php
/**
 * EnvelopeSummary
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * EnvelopeSummary Class Doc Comment
 *
 * @category    Class
 * @description This object describes an envelope.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EnvelopeSummary implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'envelopeSummary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'bulk_envelope_status' => '\DocuSign\eSign\Model\BulkEnvelopeStatus',
        'envelope_id' => '?string',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'recipient_signing_uri' => '?string',
        'recipient_signing_uri_error' => '?string',
        'status' => '?string',
        'status_date_time' => '?string',
        'uri' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'bulk_envelope_status' => null,
        'envelope_id' => null,
        'error_details' => null,
        'recipient_signing_uri' => null,
        'recipient_signing_uri_error' => null,
        'status' => null,
        'status_date_time' => null,
        'uri' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bulk_envelope_status' => 'bulkEnvelopeStatus',
        'envelope_id' => 'envelopeId',
        'error_details' => 'errorDetails',
        'recipient_signing_uri' => 'recipientSigningUri',
        'recipient_signing_uri_error' => 'recipientSigningUriError',
        'status' => 'status',
        'status_date_time' => 'statusDateTime',
        'uri' => 'uri'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bulk_envelope_status' => 'setBulkEnvelopeStatus',
        'envelope_id' => 'setEnvelopeId',
        'error_details' => 'setErrorDetails',
        'recipient_signing_uri' => 'setRecipientSigningUri',
        'recipient_signing_uri_error' => 'setRecipientSigningUriError',
        'status' => 'setStatus',
        'status_date_time' => 'setStatusDateTime',
        'uri' => 'setUri'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bulk_envelope_status' => 'getBulkEnvelopeStatus',
        'envelope_id' => 'getEnvelopeId',
        'error_details' => 'getErrorDetails',
        'recipient_signing_uri' => 'getRecipientSigningUri',
        'recipient_signing_uri_error' => 'getRecipientSigningUriError',
        'status' => 'getStatus',
        'status_date_time' => 'getStatusDateTime',
        'uri' => 'getUri'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['bulk_envelope_status'] = isset($data['bulk_envelope_status']) ? $data['bulk_envelope_status'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['recipient_signing_uri'] = isset($data['recipient_signing_uri']) ? $data['recipient_signing_uri'] : null;
        $this->container['recipient_signing_uri_error'] = isset($data['recipient_signing_uri_error']) ? $data['recipient_signing_uri_error'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_date_time'] = isset($data['status_date_time']) ? $data['status_date_time'] : null;
        $this->container['uri'] = isset($data['uri']) ? $data['uri'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bulk_envelope_status
     *
     * @return \DocuSign\eSign\Model\BulkEnvelopeStatus
     */
    public function getBulkEnvelopeStatus()
    {
        return $this->container['bulk_envelope_status'];
    }

    /**
     * Sets bulk_envelope_status
     *
     * @param \DocuSign\eSign\Model\BulkEnvelopeStatus $bulk_envelope_status An object that describes the status of the bulk send envelopes.
     *
     * @return $this
     */
    public function setBulkEnvelopeStatus($bulk_envelope_status)
    {
        $this->container['bulk_envelope_status'] = $bulk_envelope_status;

        return $this;
    }

    /**
     * Gets envelope_id
     *
     * @return ?string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     *
     * @param ?string $envelope_id The envelope ID of the envelope status that failed to post.
     *
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets error_details
     *
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets recipient_signing_uri
     *
     * @return ?string
     */
    public function getRecipientSigningUri()
    {
        return $this->container['recipient_signing_uri'];
    }

    /**
     * Sets recipient_signing_uri
     *
     * @param ?string $recipient_signing_uri 
     *
     * @return $this
     */
    public function setRecipientSigningUri($recipient_signing_uri)
    {
        $this->container['recipient_signing_uri'] = $recipient_signing_uri;

        return $this;
    }

    /**
     * Gets recipient_signing_uri_error
     *
     * @return ?string
     */
    public function getRecipientSigningUriError()
    {
        return $this->container['recipient_signing_uri_error'];
    }

    /**
     * Sets recipient_signing_uri_error
     *
     * @param ?string $recipient_signing_uri_error 
     *
     * @return $this
     */
    public function setRecipientSigningUriError($recipient_signing_uri_error)
    {
        $this->container['recipient_signing_uri_error'] = $recipient_signing_uri_error;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_date_time
     *
     * @return ?string
     */
    public function getStatusDateTime()
    {
        return $this->container['status_date_time'];
    }

    /**
     * Sets status_date_time
     *
     * @param ?string $status_date_time The DateTime that the envelope changed status (i.e. was created or sent.)
     *
     * @return $this
     */
    public function setStatusDateTime($status_date_time)
    {
        $this->container['status_date_time'] = $status_date_time;

        return $this;
    }

    /**
     * Gets uri
     *
     * @return ?string
     */
    public function getUri()
    {
        return $this->container['uri'];
    }

    /**
     * Sets uri
     *
     * @param ?string $uri 
     *
     * @return $this
     */
    public function setUri($uri)
    {
        $this->container['uri'] = $uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

