<?php
/**
 * ConnectCustomConfiguration
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * ConnectCustomConfiguration Class Doc Comment
 *
 * @category    Class
 * @description The &#x60;connectCustomConfiguration&#x60; object describes how Connect is configured for your account.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConnectCustomConfiguration implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'connectCustomConfiguration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'allow_envelope_publish' => '?string',
        'allow_salesforce_publish' => '?string',
        'all_users' => '?string',
        'all_users_except' => '?string',
        'configuration_type' => '?string',
        'connect_id' => '?string',
        'delivery_mode' => '?string',
        'disabled_by' => '?string',
        'enable_log' => '?string',
        'envelope_events' => '?string[]',
        'event_data' => '\DocuSign\eSign\Model\ConnectEventData',
        'events' => '?string[]',
        'external_folder_id' => '?string',
        'external_folder_label' => '?string',
        'group_ids' => '?string[]',
        'include_certificate_of_completion' => '?string',
        'include_cert_soap_header' => '?string',
        'include_document_fields' => '?string',
        'include_documents' => '?string',
        'include_envelope_void_reason' => '?string',
        'include_hmac' => '?string',
        'include_o_auth' => '?string',
        'include_sender_accountas_custom_field' => '?string',
        'include_time_zone_information' => '?string',
        'integrator_managed' => '?string',
        'name' => '?string',
        'password' => '?string',
        'recipient_events' => '?string[]',
        'require_mutual_tls' => '?string',
        'requires_acknowledgement' => '?string',
        'salesforce_api_version' => '?string',
        'salesforce_authcode' => '?string',
        'salesforce_call_back_url' => '?string',
        'salesforce_documents_as_content_files' => '?string',
        'sender_override' => '?string',
        'sender_selectable_items' => '?string[]',
        'sf_objects' => '\DocuSign\eSign\Model\ConnectSalesforceObject[]',
        'sign_message_with_x509_certificate' => '?string',
        'soap_namespace' => '?string',
        'url_to_publish_to' => '?string',
        'user_ids' => '?string[]',
        'user_name' => '?string',
        'use_soap_interface' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'allow_envelope_publish' => null,
        'allow_salesforce_publish' => null,
        'all_users' => null,
        'all_users_except' => null,
        'configuration_type' => null,
        'connect_id' => null,
        'delivery_mode' => null,
        'disabled_by' => null,
        'enable_log' => null,
        'envelope_events' => null,
        'event_data' => null,
        'events' => null,
        'external_folder_id' => null,
        'external_folder_label' => null,
        'group_ids' => null,
        'include_certificate_of_completion' => null,
        'include_cert_soap_header' => null,
        'include_document_fields' => null,
        'include_documents' => null,
        'include_envelope_void_reason' => null,
        'include_hmac' => null,
        'include_o_auth' => null,
        'include_sender_accountas_custom_field' => null,
        'include_time_zone_information' => null,
        'integrator_managed' => null,
        'name' => null,
        'password' => null,
        'recipient_events' => null,
        'require_mutual_tls' => null,
        'requires_acknowledgement' => null,
        'salesforce_api_version' => null,
        'salesforce_authcode' => null,
        'salesforce_call_back_url' => null,
        'salesforce_documents_as_content_files' => null,
        'sender_override' => null,
        'sender_selectable_items' => null,
        'sf_objects' => null,
        'sign_message_with_x509_certificate' => null,
        'soap_namespace' => null,
        'url_to_publish_to' => null,
        'user_ids' => null,
        'user_name' => null,
        'use_soap_interface' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_envelope_publish' => 'allowEnvelopePublish',
        'allow_salesforce_publish' => 'allowSalesforcePublish',
        'all_users' => 'allUsers',
        'all_users_except' => 'allUsersExcept',
        'configuration_type' => 'configurationType',
        'connect_id' => 'connectId',
        'delivery_mode' => 'deliveryMode',
        'disabled_by' => 'disabledBy',
        'enable_log' => 'enableLog',
        'envelope_events' => 'envelopeEvents',
        'event_data' => 'eventData',
        'events' => 'events',
        'external_folder_id' => 'externalFolderId',
        'external_folder_label' => 'externalFolderLabel',
        'group_ids' => 'groupIds',
        'include_certificate_of_completion' => 'includeCertificateOfCompletion',
        'include_cert_soap_header' => 'includeCertSoapHeader',
        'include_document_fields' => 'includeDocumentFields',
        'include_documents' => 'includeDocuments',
        'include_envelope_void_reason' => 'includeEnvelopeVoidReason',
        'include_hmac' => 'includeHMAC',
        'include_o_auth' => 'includeOAuth',
        'include_sender_accountas_custom_field' => 'includeSenderAccountasCustomField',
        'include_time_zone_information' => 'includeTimeZoneInformation',
        'integrator_managed' => 'integratorManaged',
        'name' => 'name',
        'password' => 'password',
        'recipient_events' => 'recipientEvents',
        'require_mutual_tls' => 'requireMutualTls',
        'requires_acknowledgement' => 'requiresAcknowledgement',
        'salesforce_api_version' => 'salesforceApiVersion',
        'salesforce_authcode' => 'salesforceAuthcode',
        'salesforce_call_back_url' => 'salesforceCallBackUrl',
        'salesforce_documents_as_content_files' => 'salesforceDocumentsAsContentFiles',
        'sender_override' => 'senderOverride',
        'sender_selectable_items' => 'senderSelectableItems',
        'sf_objects' => 'sfObjects',
        'sign_message_with_x509_certificate' => 'signMessageWithX509Certificate',
        'soap_namespace' => 'soapNamespace',
        'url_to_publish_to' => 'urlToPublishTo',
        'user_ids' => 'userIds',
        'user_name' => 'userName',
        'use_soap_interface' => 'useSoapInterface'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allow_envelope_publish' => 'setAllowEnvelopePublish',
        'allow_salesforce_publish' => 'setAllowSalesforcePublish',
        'all_users' => 'setAllUsers',
        'all_users_except' => 'setAllUsersExcept',
        'configuration_type' => 'setConfigurationType',
        'connect_id' => 'setConnectId',
        'delivery_mode' => 'setDeliveryMode',
        'disabled_by' => 'setDisabledBy',
        'enable_log' => 'setEnableLog',
        'envelope_events' => 'setEnvelopeEvents',
        'event_data' => 'setEventData',
        'events' => 'setEvents',
        'external_folder_id' => 'setExternalFolderId',
        'external_folder_label' => 'setExternalFolderLabel',
        'group_ids' => 'setGroupIds',
        'include_certificate_of_completion' => 'setIncludeCertificateOfCompletion',
        'include_cert_soap_header' => 'setIncludeCertSoapHeader',
        'include_document_fields' => 'setIncludeDocumentFields',
        'include_documents' => 'setIncludeDocuments',
        'include_envelope_void_reason' => 'setIncludeEnvelopeVoidReason',
        'include_hmac' => 'setIncludeHmac',
        'include_o_auth' => 'setIncludeOAuth',
        'include_sender_accountas_custom_field' => 'setIncludeSenderAccountasCustomField',
        'include_time_zone_information' => 'setIncludeTimeZoneInformation',
        'integrator_managed' => 'setIntegratorManaged',
        'name' => 'setName',
        'password' => 'setPassword',
        'recipient_events' => 'setRecipientEvents',
        'require_mutual_tls' => 'setRequireMutualTls',
        'requires_acknowledgement' => 'setRequiresAcknowledgement',
        'salesforce_api_version' => 'setSalesforceApiVersion',
        'salesforce_authcode' => 'setSalesforceAuthcode',
        'salesforce_call_back_url' => 'setSalesforceCallBackUrl',
        'salesforce_documents_as_content_files' => 'setSalesforceDocumentsAsContentFiles',
        'sender_override' => 'setSenderOverride',
        'sender_selectable_items' => 'setSenderSelectableItems',
        'sf_objects' => 'setSfObjects',
        'sign_message_with_x509_certificate' => 'setSignMessageWithX509Certificate',
        'soap_namespace' => 'setSoapNamespace',
        'url_to_publish_to' => 'setUrlToPublishTo',
        'user_ids' => 'setUserIds',
        'user_name' => 'setUserName',
        'use_soap_interface' => 'setUseSoapInterface'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allow_envelope_publish' => 'getAllowEnvelopePublish',
        'allow_salesforce_publish' => 'getAllowSalesforcePublish',
        'all_users' => 'getAllUsers',
        'all_users_except' => 'getAllUsersExcept',
        'configuration_type' => 'getConfigurationType',
        'connect_id' => 'getConnectId',
        'delivery_mode' => 'getDeliveryMode',
        'disabled_by' => 'getDisabledBy',
        'enable_log' => 'getEnableLog',
        'envelope_events' => 'getEnvelopeEvents',
        'event_data' => 'getEventData',
        'events' => 'getEvents',
        'external_folder_id' => 'getExternalFolderId',
        'external_folder_label' => 'getExternalFolderLabel',
        'group_ids' => 'getGroupIds',
        'include_certificate_of_completion' => 'getIncludeCertificateOfCompletion',
        'include_cert_soap_header' => 'getIncludeCertSoapHeader',
        'include_document_fields' => 'getIncludeDocumentFields',
        'include_documents' => 'getIncludeDocuments',
        'include_envelope_void_reason' => 'getIncludeEnvelopeVoidReason',
        'include_hmac' => 'getIncludeHmac',
        'include_o_auth' => 'getIncludeOAuth',
        'include_sender_accountas_custom_field' => 'getIncludeSenderAccountasCustomField',
        'include_time_zone_information' => 'getIncludeTimeZoneInformation',
        'integrator_managed' => 'getIntegratorManaged',
        'name' => 'getName',
        'password' => 'getPassword',
        'recipient_events' => 'getRecipientEvents',
        'require_mutual_tls' => 'getRequireMutualTls',
        'requires_acknowledgement' => 'getRequiresAcknowledgement',
        'salesforce_api_version' => 'getSalesforceApiVersion',
        'salesforce_authcode' => 'getSalesforceAuthcode',
        'salesforce_call_back_url' => 'getSalesforceCallBackUrl',
        'salesforce_documents_as_content_files' => 'getSalesforceDocumentsAsContentFiles',
        'sender_override' => 'getSenderOverride',
        'sender_selectable_items' => 'getSenderSelectableItems',
        'sf_objects' => 'getSfObjects',
        'sign_message_with_x509_certificate' => 'getSignMessageWithX509Certificate',
        'soap_namespace' => 'getSoapNamespace',
        'url_to_publish_to' => 'getUrlToPublishTo',
        'user_ids' => 'getUserIds',
        'user_name' => 'getUserName',
        'use_soap_interface' => 'getUseSoapInterface'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allow_envelope_publish'] = isset($data['allow_envelope_publish']) ? $data['allow_envelope_publish'] : null;
        $this->container['allow_salesforce_publish'] = isset($data['allow_salesforce_publish']) ? $data['allow_salesforce_publish'] : null;
        $this->container['all_users'] = isset($data['all_users']) ? $data['all_users'] : null;
        $this->container['all_users_except'] = isset($data['all_users_except']) ? $data['all_users_except'] : null;
        $this->container['configuration_type'] = isset($data['configuration_type']) ? $data['configuration_type'] : null;
        $this->container['connect_id'] = isset($data['connect_id']) ? $data['connect_id'] : null;
        $this->container['delivery_mode'] = isset($data['delivery_mode']) ? $data['delivery_mode'] : null;
        $this->container['disabled_by'] = isset($data['disabled_by']) ? $data['disabled_by'] : null;
        $this->container['enable_log'] = isset($data['enable_log']) ? $data['enable_log'] : null;
        $this->container['envelope_events'] = isset($data['envelope_events']) ? $data['envelope_events'] : null;
        $this->container['event_data'] = isset($data['event_data']) ? $data['event_data'] : null;
        $this->container['events'] = isset($data['events']) ? $data['events'] : null;
        $this->container['external_folder_id'] = isset($data['external_folder_id']) ? $data['external_folder_id'] : null;
        $this->container['external_folder_label'] = isset($data['external_folder_label']) ? $data['external_folder_label'] : null;
        $this->container['group_ids'] = isset($data['group_ids']) ? $data['group_ids'] : null;
        $this->container['include_certificate_of_completion'] = isset($data['include_certificate_of_completion']) ? $data['include_certificate_of_completion'] : null;
        $this->container['include_cert_soap_header'] = isset($data['include_cert_soap_header']) ? $data['include_cert_soap_header'] : null;
        $this->container['include_document_fields'] = isset($data['include_document_fields']) ? $data['include_document_fields'] : null;
        $this->container['include_documents'] = isset($data['include_documents']) ? $data['include_documents'] : null;
        $this->container['include_envelope_void_reason'] = isset($data['include_envelope_void_reason']) ? $data['include_envelope_void_reason'] : null;
        $this->container['include_hmac'] = isset($data['include_hmac']) ? $data['include_hmac'] : null;
        $this->container['include_o_auth'] = isset($data['include_o_auth']) ? $data['include_o_auth'] : null;
        $this->container['include_sender_accountas_custom_field'] = isset($data['include_sender_accountas_custom_field']) ? $data['include_sender_accountas_custom_field'] : null;
        $this->container['include_time_zone_information'] = isset($data['include_time_zone_information']) ? $data['include_time_zone_information'] : null;
        $this->container['integrator_managed'] = isset($data['integrator_managed']) ? $data['integrator_managed'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['recipient_events'] = isset($data['recipient_events']) ? $data['recipient_events'] : null;
        $this->container['require_mutual_tls'] = isset($data['require_mutual_tls']) ? $data['require_mutual_tls'] : null;
        $this->container['requires_acknowledgement'] = isset($data['requires_acknowledgement']) ? $data['requires_acknowledgement'] : null;
        $this->container['salesforce_api_version'] = isset($data['salesforce_api_version']) ? $data['salesforce_api_version'] : null;
        $this->container['salesforce_authcode'] = isset($data['salesforce_authcode']) ? $data['salesforce_authcode'] : null;
        $this->container['salesforce_call_back_url'] = isset($data['salesforce_call_back_url']) ? $data['salesforce_call_back_url'] : null;
        $this->container['salesforce_documents_as_content_files'] = isset($data['salesforce_documents_as_content_files']) ? $data['salesforce_documents_as_content_files'] : null;
        $this->container['sender_override'] = isset($data['sender_override']) ? $data['sender_override'] : null;
        $this->container['sender_selectable_items'] = isset($data['sender_selectable_items']) ? $data['sender_selectable_items'] : null;
        $this->container['sf_objects'] = isset($data['sf_objects']) ? $data['sf_objects'] : null;
        $this->container['sign_message_with_x509_certificate'] = isset($data['sign_message_with_x509_certificate']) ? $data['sign_message_with_x509_certificate'] : null;
        $this->container['soap_namespace'] = isset($data['soap_namespace']) ? $data['soap_namespace'] : null;
        $this->container['url_to_publish_to'] = isset($data['url_to_publish_to']) ? $data['url_to_publish_to'] : null;
        $this->container['user_ids'] = isset($data['user_ids']) ? $data['user_ids'] : null;
        $this->container['user_name'] = isset($data['user_name']) ? $data['user_name'] : null;
        $this->container['use_soap_interface'] = isset($data['use_soap_interface']) ? $data['use_soap_interface'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allow_envelope_publish
     *
     * @return ?string
     */
    public function getAllowEnvelopePublish()
    {
        return $this->container['allow_envelope_publish'];
    }

    /**
     * Sets allow_envelope_publish
     *
     * @param ?string $allow_envelope_publish When set to **true**, data is sent to the urlToPublishTo web address. This option can be set to false to stop sending data while maintaining the Connect configuration information.
     *
     * @return $this
     */
    public function setAllowEnvelopePublish($allow_envelope_publish)
    {
        $this->container['allow_envelope_publish'] = $allow_envelope_publish;

        return $this;
    }

    /**
     * Gets allow_salesforce_publish
     *
     * @return ?string
     */
    public function getAllowSalesforcePublish()
    {
        return $this->container['allow_salesforce_publish'];
    }

    /**
     * Sets allow_salesforce_publish
     *
     * @param ?string $allow_salesforce_publish 
     *
     * @return $this
     */
    public function setAllowSalesforcePublish($allow_salesforce_publish)
    {
        $this->container['allow_salesforce_publish'] = $allow_salesforce_publish;

        return $this;
    }

    /**
     * Gets all_users
     *
     * @return ?string
     */
    public function getAllUsers()
    {
        return $this->container['all_users'];
    }

    /**
     * Sets all_users
     *
     * @param ?string $all_users When set to **true**, the tracked envelope and recipient events for all users, including users that are added a later time, are sent through Connect.
     *
     * @return $this
     */
    public function setAllUsers($all_users)
    {
        $this->container['all_users'] = $all_users;

        return $this;
    }

    /**
     * Gets all_users_except
     *
     * @return ?string
     */
    public function getAllUsersExcept()
    {
        return $this->container['all_users_except'];
    }

    /**
     * Sets all_users_except
     *
     * @param ?string $all_users_except 
     *
     * @return $this
     */
    public function setAllUsersExcept($all_users_except)
    {
        $this->container['all_users_except'] = $all_users_except;

        return $this;
    }

    /**
     * Gets configuration_type
     *
     * @return ?string
     */
    public function getConfigurationType()
    {
        return $this->container['configuration_type'];
    }

    /**
     * Sets configuration_type
     *
     * @param ?string $configuration_type If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.
     *
     * @return $this
     */
    public function setConfigurationType($configuration_type)
    {
        $this->container['configuration_type'] = $configuration_type;

        return $this;
    }

    /**
     * Gets connect_id
     *
     * @return ?string
     */
    public function getConnectId()
    {
        return $this->container['connect_id'];
    }

    /**
     * Sets connect_id
     *
     * @param ?string $connect_id Specifies the DocuSign generated ID for the Connect configuration.
     *
     * @return $this
     */
    public function setConnectId($connect_id)
    {
        $this->container['connect_id'] = $connect_id;

        return $this;
    }

    /**
     * Gets delivery_mode
     *
     * @return ?string
     */
    public function getDeliveryMode()
    {
        return $this->container['delivery_mode'];
    }

    /**
     * Sets delivery_mode
     *
     * @param ?string $delivery_mode 
     *
     * @return $this
     */
    public function setDeliveryMode($delivery_mode)
    {
        $this->container['delivery_mode'] = $delivery_mode;

        return $this;
    }

    /**
     * Gets disabled_by
     *
     * @return ?string
     */
    public function getDisabledBy()
    {
        return $this->container['disabled_by'];
    }

    /**
     * Sets disabled_by
     *
     * @param ?string $disabled_by 
     *
     * @return $this
     */
    public function setDisabledBy($disabled_by)
    {
        $this->container['disabled_by'] = $disabled_by;

        return $this;
    }

    /**
     * Gets enable_log
     *
     * @return ?string
     */
    public function getEnableLog()
    {
        return $this->container['enable_log'];
    }

    /**
     * Sets enable_log
     *
     * @param ?string $enable_log This turns Connect logging on or off. When set to **true**, logging is turned on.
     *
     * @return $this
     */
    public function setEnableLog($enable_log)
    {
        $this->container['enable_log'] = $enable_log;

        return $this;
    }

    /**
     * Gets envelope_events
     *
     * @return ?string[]
     */
    public function getEnvelopeEvents()
    {
        return $this->container['envelope_events'];
    }

    /**
     * Sets envelope_events
     *
     * @param ?string[] $envelope_events A comma separated list of ï¿½Envelopeï¿½ related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, and Voided.
     *
     * @return $this
     */
    public function setEnvelopeEvents($envelope_events)
    {
        $this->container['envelope_events'] = $envelope_events;

        return $this;
    }

    /**
     * Gets event_data
     *
     * @return \DocuSign\eSign\Model\ConnectEventData
     */
    public function getEventData()
    {
        return $this->container['event_data'];
    }

    /**
     * Sets event_data
     *
     * @param \DocuSign\eSign\Model\ConnectEventData $event_data Allows you to specify the format of the information the Connect webhooks returns. For more information, see [Connect webhooks with JSON notifications](https://www.docusign.com/blog/developers/connect-webhooks-json-notifications)
     *
     * @return $this
     */
    public function setEventData($event_data)
    {
        $this->container['event_data'] = $event_data;

        return $this;
    }

    /**
     * Gets events
     *
     * @return ?string[]
     */
    public function getEvents()
    {
        return $this->container['events'];
    }

    /**
     * Sets events
     *
     * @param ?string[] $events 
     *
     * @return $this
     */
    public function setEvents($events)
    {
        $this->container['events'] = $events;

        return $this;
    }

    /**
     * Gets external_folder_id
     *
     * @return ?string
     */
    public function getExternalFolderId()
    {
        return $this->container['external_folder_id'];
    }

    /**
     * Sets external_folder_id
     *
     * @param ?string $external_folder_id 
     *
     * @return $this
     */
    public function setExternalFolderId($external_folder_id)
    {
        $this->container['external_folder_id'] = $external_folder_id;

        return $this;
    }

    /**
     * Gets external_folder_label
     *
     * @return ?string
     */
    public function getExternalFolderLabel()
    {
        return $this->container['external_folder_label'];
    }

    /**
     * Sets external_folder_label
     *
     * @param ?string $external_folder_label 
     *
     * @return $this
     */
    public function setExternalFolderLabel($external_folder_label)
    {
        $this->container['external_folder_label'] = $external_folder_label;

        return $this;
    }

    /**
     * Gets group_ids
     *
     * @return ?string[]
     */
    public function getGroupIds()
    {
        return $this->container['group_ids'];
    }

    /**
     * Sets group_ids
     *
     * @param ?string[] $group_ids 
     *
     * @return $this
     */
    public function setGroupIds($group_ids)
    {
        $this->container['group_ids'] = $group_ids;

        return $this;
    }

    /**
     * Gets include_certificate_of_completion
     *
     * @return ?string
     */
    public function getIncludeCertificateOfCompletion()
    {
        return $this->container['include_certificate_of_completion'];
    }

    /**
     * Sets include_certificate_of_completion
     *
     * @param ?string $include_certificate_of_completion When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes.
     *
     * @return $this
     */
    public function setIncludeCertificateOfCompletion($include_certificate_of_completion)
    {
        $this->container['include_certificate_of_completion'] = $include_certificate_of_completion;

        return $this;
    }

    /**
     * Gets include_cert_soap_header
     *
     * @return ?string
     */
    public function getIncludeCertSoapHeader()
    {
        return $this->container['include_cert_soap_header'];
    }

    /**
     * Sets include_cert_soap_header
     *
     * @param ?string $include_cert_soap_header 
     *
     * @return $this
     */
    public function setIncludeCertSoapHeader($include_cert_soap_header)
    {
        $this->container['include_cert_soap_header'] = $include_cert_soap_header;

        return $this;
    }

    /**
     * Gets include_document_fields
     *
     * @return ?string
     */
    public function getIncludeDocumentFields()
    {
        return $this->container['include_document_fields'];
    }

    /**
     * Sets include_document_fields
     *
     * @param ?string $include_document_fields When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API.
     *
     * @return $this
     */
    public function setIncludeDocumentFields($include_document_fields)
    {
        $this->container['include_document_fields'] = $include_document_fields;

        return $this;
    }

    /**
     * Gets include_documents
     *
     * @return ?string
     */
    public function getIncludeDocuments()
    {
        return $this->container['include_documents'];
    }

    /**
     * Sets include_documents
     *
     * @param ?string $include_documents When set to **true**, Connect will send the PDF document along with the update XML.
     *
     * @return $this
     */
    public function setIncludeDocuments($include_documents)
    {
        $this->container['include_documents'] = $include_documents;

        return $this;
    }

    /**
     * Gets include_envelope_void_reason
     *
     * @return ?string
     */
    public function getIncludeEnvelopeVoidReason()
    {
        return $this->container['include_envelope_void_reason'];
    }

    /**
     * Sets include_envelope_void_reason
     *
     * @param ?string $include_envelope_void_reason When set to **true**, Connect will include the voidedReason for voided envelopes.
     *
     * @return $this
     */
    public function setIncludeEnvelopeVoidReason($include_envelope_void_reason)
    {
        $this->container['include_envelope_void_reason'] = $include_envelope_void_reason;

        return $this;
    }

    /**
     * Gets include_hmac
     *
     * @return ?string
     */
    public function getIncludeHmac()
    {
        return $this->container['include_hmac'];
    }

    /**
     * Sets include_hmac
     *
     * @param ?string $include_hmac 
     *
     * @return $this
     */
    public function setIncludeHmac($include_hmac)
    {
        $this->container['include_hmac'] = $include_hmac;

        return $this;
    }

    /**
     * Gets include_o_auth
     *
     * @return ?string
     */
    public function getIncludeOAuth()
    {
        return $this->container['include_o_auth'];
    }

    /**
     * Sets include_o_auth
     *
     * @param ?string $include_o_auth 
     *
     * @return $this
     */
    public function setIncludeOAuth($include_o_auth)
    {
        $this->container['include_o_auth'] = $include_o_auth;

        return $this;
    }

    /**
     * Gets include_sender_accountas_custom_field
     *
     * @return ?string
     */
    public function getIncludeSenderAccountasCustomField()
    {
        return $this->container['include_sender_accountas_custom_field'];
    }

    /**
     * Sets include_sender_accountas_custom_field
     *
     * @param ?string $include_sender_accountas_custom_field When set to **true**, Connect will include the sender account as Custom Field in the data.
     *
     * @return $this
     */
    public function setIncludeSenderAccountasCustomField($include_sender_accountas_custom_field)
    {
        $this->container['include_sender_accountas_custom_field'] = $include_sender_accountas_custom_field;

        return $this;
    }

    /**
     * Gets include_time_zone_information
     *
     * @return ?string
     */
    public function getIncludeTimeZoneInformation()
    {
        return $this->container['include_time_zone_information'];
    }

    /**
     * Sets include_time_zone_information
     *
     * @param ?string $include_time_zone_information When set to **true**, Connect will include the envelope time zone information.
     *
     * @return $this
     */
    public function setIncludeTimeZoneInformation($include_time_zone_information)
    {
        $this->container['include_time_zone_information'] = $include_time_zone_information;

        return $this;
    }

    /**
     * Gets integrator_managed
     *
     * @return ?string
     */
    public function getIntegratorManaged()
    {
        return $this->container['integrator_managed'];
    }

    /**
     * Sets integrator_managed
     *
     * @param ?string $integrator_managed 
     *
     * @return $this
     */
    public function setIntegratorManaged($integrator_managed)
    {
        $this->container['integrator_managed'] = $integrator_managed;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name The name of the Connect configuration. The name helps identify the configuration in the list.
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets password
     *
     * @return ?string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     *
     * @param ?string $password 
     *
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets recipient_events
     *
     * @return ?string[]
     */
    public function getRecipientEvents()
    {
        return $this->container['recipient_events'];
    }

    /**
     * Sets recipient_events
     *
     * @param ?string[] $recipient_events A comma separated list of ï¿½Recipientï¿½ related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, AuthenticationFailed, and AutoResponded.
     *
     * @return $this
     */
    public function setRecipientEvents($recipient_events)
    {
        $this->container['recipient_events'] = $recipient_events;

        return $this;
    }

    /**
     * Gets require_mutual_tls
     *
     * @return ?string
     */
    public function getRequireMutualTls()
    {
        return $this->container['require_mutual_tls'];
    }

    /**
     * Sets require_mutual_tls
     *
     * @param ?string $require_mutual_tls 
     *
     * @return $this
     */
    public function setRequireMutualTls($require_mutual_tls)
    {
        $this->container['require_mutual_tls'] = $require_mutual_tls;

        return $this;
    }

    /**
     * Gets requires_acknowledgement
     *
     * @return ?string
     */
    public function getRequiresAcknowledgement()
    {
        return $this->container['requires_acknowledgement'];
    }

    /**
     * Sets requires_acknowledgement
     *
     * @param ?string $requires_acknowledgement When set to **true**, and a publication message fails to be acknowledged, the message goes back into the queue and the system will retry delivery after a successful acknowledgement is received. If the delivery fails a second time, the message is not returned to the queue for sending until Connect receives a successful acknowledgement and it has been at least 24 hours since the previous retry. There is a maximum of ten retries Alternately, you can use Republish Connect Information to manually republish the envelope information.
     *
     * @return $this
     */
    public function setRequiresAcknowledgement($requires_acknowledgement)
    {
        $this->container['requires_acknowledgement'] = $requires_acknowledgement;

        return $this;
    }

    /**
     * Gets salesforce_api_version
     *
     * @return ?string
     */
    public function getSalesforceApiVersion()
    {
        return $this->container['salesforce_api_version'];
    }

    /**
     * Sets salesforce_api_version
     *
     * @param ?string $salesforce_api_version 
     *
     * @return $this
     */
    public function setSalesforceApiVersion($salesforce_api_version)
    {
        $this->container['salesforce_api_version'] = $salesforce_api_version;

        return $this;
    }

    /**
     * Gets salesforce_authcode
     *
     * @return ?string
     */
    public function getSalesforceAuthcode()
    {
        return $this->container['salesforce_authcode'];
    }

    /**
     * Sets salesforce_authcode
     *
     * @param ?string $salesforce_authcode 
     *
     * @return $this
     */
    public function setSalesforceAuthcode($salesforce_authcode)
    {
        $this->container['salesforce_authcode'] = $salesforce_authcode;

        return $this;
    }

    /**
     * Gets salesforce_call_back_url
     *
     * @return ?string
     */
    public function getSalesforceCallBackUrl()
    {
        return $this->container['salesforce_call_back_url'];
    }

    /**
     * Sets salesforce_call_back_url
     *
     * @param ?string $salesforce_call_back_url 
     *
     * @return $this
     */
    public function setSalesforceCallBackUrl($salesforce_call_back_url)
    {
        $this->container['salesforce_call_back_url'] = $salesforce_call_back_url;

        return $this;
    }

    /**
     * Gets salesforce_documents_as_content_files
     *
     * @return ?string
     */
    public function getSalesforceDocumentsAsContentFiles()
    {
        return $this->container['salesforce_documents_as_content_files'];
    }

    /**
     * Sets salesforce_documents_as_content_files
     *
     * @param ?string $salesforce_documents_as_content_files 
     *
     * @return $this
     */
    public function setSalesforceDocumentsAsContentFiles($salesforce_documents_as_content_files)
    {
        $this->container['salesforce_documents_as_content_files'] = $salesforce_documents_as_content_files;

        return $this;
    }

    /**
     * Gets sender_override
     *
     * @return ?string
     */
    public function getSenderOverride()
    {
        return $this->container['sender_override'];
    }

    /**
     * Sets sender_override
     *
     * @param ?string $sender_override 
     *
     * @return $this
     */
    public function setSenderOverride($sender_override)
    {
        $this->container['sender_override'] = $sender_override;

        return $this;
    }

    /**
     * Gets sender_selectable_items
     *
     * @return ?string[]
     */
    public function getSenderSelectableItems()
    {
        return $this->container['sender_selectable_items'];
    }

    /**
     * Sets sender_selectable_items
     *
     * @param ?string[] $sender_selectable_items 
     *
     * @return $this
     */
    public function setSenderSelectableItems($sender_selectable_items)
    {
        $this->container['sender_selectable_items'] = $sender_selectable_items;

        return $this;
    }

    /**
     * Gets sf_objects
     *
     * @return \DocuSign\eSign\Model\ConnectSalesforceObject[]
     */
    public function getSfObjects()
    {
        return $this->container['sf_objects'];
    }

    /**
     * Sets sf_objects
     *
     * @param \DocuSign\eSign\Model\ConnectSalesforceObject[] $sf_objects 
     *
     * @return $this
     */
    public function setSfObjects($sf_objects)
    {
        $this->container['sf_objects'] = $sf_objects;

        return $this;
    }

    /**
     * Gets sign_message_with_x509_certificate
     *
     * @return ?string
     */
    public function getSignMessageWithX509Certificate()
    {
        return $this->container['sign_message_with_x509_certificate'];
    }

    /**
     * Sets sign_message_with_x509_certificate
     *
     * @param ?string $sign_message_with_x509_certificate When set to **true**, Connect messages are signed with an X509 certificate. This provides support for 2-way SSL.
     *
     * @return $this
     */
    public function setSignMessageWithX509Certificate($sign_message_with_x509_certificate)
    {
        $this->container['sign_message_with_x509_certificate'] = $sign_message_with_x509_certificate;

        return $this;
    }

    /**
     * Gets soap_namespace
     *
     * @return ?string
     */
    public function getSoapNamespace()
    {
        return $this->container['soap_namespace'];
    }

    /**
     * Sets soap_namespace
     *
     * @param ?string $soap_namespace The namespace of the SOAP interface.  The namespace value must be set if useSoapInterface is set to true.
     *
     * @return $this
     */
    public function setSoapNamespace($soap_namespace)
    {
        $this->container['soap_namespace'] = $soap_namespace;

        return $this;
    }

    /**
     * Gets url_to_publish_to
     *
     * @return ?string
     */
    public function getUrlToPublishTo()
    {
        return $this->container['url_to_publish_to'];
    }

    /**
     * Sets url_to_publish_to
     *
     * @param ?string $url_to_publish_to This is the web address and name of your listener or Retrieving Service endpoint. You need to include HTTPS:// in the web address.
     *
     * @return $this
     */
    public function setUrlToPublishTo($url_to_publish_to)
    {
        $this->container['url_to_publish_to'] = $url_to_publish_to;

        return $this;
    }

    /**
     * Gets user_ids
     *
     * @return ?string[]
     */
    public function getUserIds()
    {
        return $this->container['user_ids'];
    }

    /**
     * Sets user_ids
     *
     * @param ?string[] $user_ids A comma separated list of userIds. This sets the users associated with the tracked envelope and recipient events. When one of the event occurs for a set user, the information is sent through Connect.   ###### Note: If allUsers is set to ï¿½falseï¿½ then you must provide a list of user idï¿½s.
     *
     * @return $this
     */
    public function setUserIds($user_ids)
    {
        $this->container['user_ids'] = $user_ids;

        return $this;
    }

    /**
     * Gets user_name
     *
     * @return ?string
     */
    public function getUserName()
    {
        return $this->container['user_name'];
    }

    /**
     * Sets user_name
     *
     * @param ?string $user_name 
     *
     * @return $this
     */
    public function setUserName($user_name)
    {
        $this->container['user_name'] = $user_name;

        return $this;
    }

    /**
     * Gets use_soap_interface
     *
     * @return ?string
     */
    public function getUseSoapInterface()
    {
        return $this->container['use_soap_interface'];
    }

    /**
     * Sets use_soap_interface
     *
     * @param ?string $use_soap_interface When set to **true**, indicates that the `urlToPublishTo` property contains a SOAP endpoint.
     *
     * @return $this
     */
    public function setUseSoapInterface($use_soap_interface)
    {
        $this->container['use_soap_interface'] = $use_soap_interface;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

