<?php
declare(strict_types=1);

/**
 * ConnectApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\ConnectApi;


/**
 * GetConnectAllUsersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetConnectAllUsersOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $domain_users_only 
      * @var ?string
      */
    protected ?string $domain_users_only = null;

    /**
     * Gets domain_users_only
     *
     * @return ?string
     */
    public function getDomainUsersOnly(): ?string
    {
        return $this->domain_users_only;
    }

    /**
     * Sets domain_users_only
     * @param ?string $domain_users_only 
     *
     * @return self
     */
    public function setDomainUsersOnly(?string $domain_users_only): self
    {
        $this->domain_users_only = $domain_users_only;
        return $this;
    }
    /**
      * $email_substring 
      * @var ?string
      */
    protected ?string $email_substring = null;

    /**
     * Gets email_substring
     *
     * @return ?string
     */
    public function getEmailSubstring(): ?string
    {
        return $this->email_substring;
    }

    /**
     * Sets email_substring
     * @param ?string $email_substring 
     *
     * @return self
     */
    public function setEmailSubstring(?string $email_substring): self
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $user_name_substring 
      * @var ?string
      */
    protected ?string $user_name_substring = null;

    /**
     * Gets user_name_substring
     *
     * @return ?string
     */
    public function getUserNameSubstring(): ?string
    {
        return $this->user_name_substring;
    }

    /**
     * Sets user_name_substring
     * @param ?string $user_name_substring 
     *
     * @return self
     */
    public function setUserNameSubstring(?string $user_name_substring): self
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}


/**
 * GetEventLogOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetEventLogOptions
{
    /**
      * $additional_info When true, the connectDebugLog information is included in the response.
      * @var ?string
      */
    protected ?string $additional_info = null;

    /**
     * Gets additional_info
     *
     * @return ?string
     */
    public function getAdditionalInfo(): ?string
    {
        return $this->additional_info;
    }

    /**
     * Sets additional_info
     * @param ?string $additional_info When true, the connectDebugLog information is included in the response.
     *
     * @return self
     */
    public function setAdditionalInfo(?string $additional_info): self
    {
        $this->additional_info = $additional_info;
        return $this;
    }
}


/**
 * ListEventFailureLogsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListEventFailureLogsOptions
{
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}


/**
 * ListEventLogsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListEventLogsOptions
{
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}


/**
 * ListUsersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListUsersOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $email_substring 
      * @var ?string
      */
    protected ?string $email_substring = null;

    /**
     * Gets email_substring
     *
     * @return ?string
     */
    public function getEmailSubstring(): ?string
    {
        return $this->email_substring;
    }

    /**
     * Sets email_substring
     * @param ?string $email_substring 
     *
     * @return self
     */
    public function setEmailSubstring(?string $email_substring): self
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $list_included_users 
      * @var ?string
      */
    protected ?string $list_included_users = null;

    /**
     * Gets list_included_users
     *
     * @return ?string
     */
    public function getListIncludedUsers(): ?string
    {
        return $this->list_included_users;
    }

    /**
     * Sets list_included_users
     * @param ?string $list_included_users 
     *
     * @return self
     */
    public function setListIncludedUsers(?string $list_included_users): self
    {
        $this->list_included_users = $list_included_users;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $user_name_substring 
      * @var ?string
      */
    protected ?string $user_name_substring = null;

    /**
     * Gets user_name_substring
     *
     * @return ?string
     */
    public function getUserNameSubstring(): ?string
    {
        return $this->user_name_substring;
    }

    /**
     * Sets user_name_substring
     * @param ?string $user_name_substring 
     *
     * @return self
     */
    public function setUserNameSubstring(?string $user_name_substring): self
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * ConnectApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ConnectApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createConfiguration
     *
     * Creates a connect configuration for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectCustomConfiguration
     */
    public function createConfiguration($account_id, $connect_custom_configuration = null)
    {
        list($response) = $this->createConfigurationWithHttpInfo($account_id, $connect_custom_configuration);
        return $response;
    }

    /**
     * Operation createConfigurationWithHttpInfo
     *
     * Creates a connect configuration for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectCustomConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConfigurationWithHttpInfo($account_id, $connect_custom_configuration = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_custom_configuration)) {
            $_tempBody = $connect_custom_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectCustomConfiguration',
                '/v2.1/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectCustomConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectCustomConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createConnectOAuthConfig
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectOAuthConfig $connect_o_auth_config  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectOAuthConfig
     */
    public function createConnectOAuthConfig($account_id, $connect_o_auth_config = null)
    {
        list($response) = $this->createConnectOAuthConfigWithHttpInfo($account_id, $connect_o_auth_config);
        return $response;
    }

    /**
     * Operation createConnectOAuthConfigWithHttpInfo
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectOAuthConfig $connect_o_auth_config  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectOAuthConfig, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConnectOAuthConfigWithHttpInfo($account_id, $connect_o_auth_config = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createConnectOAuthConfig');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/oauth";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_o_auth_config)) {
            $_tempBody = $connect_o_auth_config;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectOAuthConfig',
                '/v2.1/accounts/{accountId}/connect/oauth'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectOAuthConfig', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectOAuthConfig', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteConfiguration
     *
     * Deletes the specified connect configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteConfiguration($account_id, $connect_id)
    {
        list($response) = $this->deleteConfigurationWithHttpInfo($account_id, $connect_id);
        return $response;
    }

    /**
     * Operation deleteConfigurationWithHttpInfo
     *
     * Deletes the specified connect configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConfigurationWithHttpInfo($account_id, $connect_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteConfiguration');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling deleteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/{connectId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "connectId", $connect_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/connect/{connectId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteConnectOAuthConfig
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteConnectOAuthConfig($account_id)
    {
        list($response) = $this->deleteConnectOAuthConfigWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteConnectOAuthConfigWithHttpInfo
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConnectOAuthConfigWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteConnectOAuthConfig');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/oauth";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/connect/oauth'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventFailureLog
     *
     * Deletes a Connect failure log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $failure_id The ID of the failed connect log entry.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectDeleteFailureResult
     */
    public function deleteEventFailureLog($account_id, $failure_id)
    {
        list($response) = $this->deleteEventFailureLogWithHttpInfo($account_id, $failure_id);
        return $response;
    }

    /**
     * Operation deleteEventFailureLogWithHttpInfo
     *
     * Deletes a Connect failure log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $failure_id The ID of the failed connect log entry.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectDeleteFailureResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventFailureLogWithHttpInfo($account_id, $failure_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventFailureLog');
        }
        // verify the required parameter 'failure_id' is set
        if ($failure_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $failure_id when calling deleteEventFailureLog');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/failures/{failureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($failure_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "failureId", $failure_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectDeleteFailureResult',
                '/v2.1/accounts/{accountId}/connect/failures/{failureId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectDeleteFailureResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectDeleteFailureResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventLog
     *
     * Deletes a specified Connect log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $log_id The ID of the connect log entry
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEventLog($account_id, $log_id)
    {
        list($response) = $this->deleteEventLogWithHttpInfo($account_id, $log_id);
        return $response;
    }

    /**
     * Operation deleteEventLogWithHttpInfo
     *
     * Deletes a specified Connect log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $log_id The ID of the connect log entry
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventLogWithHttpInfo($account_id, $log_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventLog');
        }
        // verify the required parameter 'log_id' is set
        if ($log_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $log_id when calling deleteEventLog');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/logs/{logId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($log_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "logId", $log_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/connect/logs/{logId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEventLogs
     *
     * Gets a list of Connect log entries.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEventLogs($account_id)
    {
        list($response) = $this->deleteEventLogsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteEventLogsWithHttpInfo
     *
     * Gets a list of Connect log entries.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEventLogsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEventLogs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/logs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/connect/logs'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteMobileNotifiers
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function deleteMobileNotifiers($account_id, $mobile_notifier_configuration_information = null)
    {
        list($response) = $this->deleteMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information);
        return $response;
    }

    /**
     * Operation deleteMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($mobile_notifier_configuration_information)) {
            $_tempBody = $mobile_notifier_configuration_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2.1/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConfiguration
     *
     * Get a Connect Configuration Information
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectConfigResults
     */
    public function getConfiguration($account_id, $connect_id)
    {
        list($response) = $this->getConfigurationWithHttpInfo($account_id, $connect_id);
        return $response;
    }

    /**
     * Operation getConfigurationWithHttpInfo
     *
     * Get a Connect Configuration Information
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectConfigResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConfigurationWithHttpInfo($account_id, $connect_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConfiguration');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling getConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/{connectId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "connectId", $connect_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectConfigResults',
                '/v2.1/accounts/{accountId}/connect/{connectId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectConfigResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectConfigResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConnectAllUsers
     *
     * Returns all users from the configured Connect service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  \DocuSign\eSign\Api\ConnectApi\GetConnectAllUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\IntegratedConnectUserInfoList
     */
    public function getConnectAllUsers($account_id, $connect_id, \DocuSign\eSign\Api\ConnectApi\GetConnectAllUsersOptions $options = null)
    {
        list($response) = $this->getConnectAllUsersWithHttpInfo($account_id, $connect_id, $options);
        return $response;
    }

    /**
     * Operation getConnectAllUsersWithHttpInfo
     *
     * Returns all users from the configured Connect service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  \DocuSign\eSign\Api\ConnectApi\GetConnectAllUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\IntegratedConnectUserInfoList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConnectAllUsersWithHttpInfo($account_id, $connect_id, \DocuSign\eSign\Api\ConnectApi\GetConnectAllUsersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConnectAllUsers');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling getConnectAllUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/{connectId}/all/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getDomainUsersOnly() != 'null') {
                $queryParams['domain_users_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getDomainUsersOnly());
            }
            if ($options->getEmailSubstring() != 'null') {
                $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getUserNameSubstring() != 'null') {
                $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "connectId", $connect_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\IntegratedConnectUserInfoList',
                '/v2.1/accounts/{accountId}/connect/{connectId}/all/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\IntegratedConnectUserInfoList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\IntegratedConnectUserInfoList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConnectOAuthConfig
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectOAuthConfig
     */
    public function getConnectOAuthConfig($account_id)
    {
        list($response) = $this->getConnectOAuthConfigWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getConnectOAuthConfigWithHttpInfo
     *
     * Sets the Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectOAuthConfig, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConnectOAuthConfigWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConnectOAuthConfig');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/oauth";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectOAuthConfig',
                '/v2.1/accounts/{accountId}/connect/oauth'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectOAuthConfig', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectOAuthConfig', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEventLog
     *
     * Get the specified Connect log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $log_id The ID of the connect log entry
     * @param  \DocuSign\eSign\Api\ConnectApi\GetEventLogOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLog
     */
    public function getEventLog($account_id, $log_id, \DocuSign\eSign\Api\ConnectApi\GetEventLogOptions $options = null)
    {
        list($response) = $this->getEventLogWithHttpInfo($account_id, $log_id, $options);
        return $response;
    }

    /**
     * Operation getEventLogWithHttpInfo
     *
     * Get the specified Connect log entry.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $log_id The ID of the connect log entry
     * @param  \DocuSign\eSign\Api\ConnectApi\GetEventLogOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLog, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEventLogWithHttpInfo($account_id, $log_id, \DocuSign\eSign\Api\ConnectApi\GetEventLogOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEventLog');
        }
        // verify the required parameter 'log_id' is set
        if ($log_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $log_id when calling getEventLog');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/logs/{logId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAdditionalInfo() != 'null') {
                $queryParams['additional_info'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdditionalInfo());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($log_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "logId", $log_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLog',
                '/v2.1/accounts/{accountId}/connect/logs/{logId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLog', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLog', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listConfigurations
     *
     * Get Connect Configuration Information
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectConfigResults
     */
    public function listConfigurations($account_id)
    {
        list($response) = $this->listConfigurationsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listConfigurationsWithHttpInfo
     *
     * Get Connect Configuration Information
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectConfigResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function listConfigurationsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listConfigurations');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectConfigResults',
                '/v2.1/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectConfigResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectConfigResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listEventFailureLogs
     *
     * Gets the Connect failure log information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListEventFailureLogsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLogs
     */
    public function listEventFailureLogs($account_id, \DocuSign\eSign\Api\ConnectApi\ListEventFailureLogsOptions $options = null)
    {
        list($response) = $this->listEventFailureLogsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listEventFailureLogsWithHttpInfo
     *
     * Gets the Connect failure log information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListEventFailureLogsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLogs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listEventFailureLogsWithHttpInfo($account_id, \DocuSign\eSign\Api\ConnectApi\ListEventFailureLogsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listEventFailureLogs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/failures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLogs',
                '/v2.1/accounts/{accountId}/connect/failures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLogs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLogs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listEventLogs
     *
     * Gets the Connect log.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListEventLogsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectLogs
     */
    public function listEventLogs($account_id, \DocuSign\eSign\Api\ConnectApi\ListEventLogsOptions $options = null)
    {
        list($response) = $this->listEventLogsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listEventLogsWithHttpInfo
     *
     * Gets the Connect log.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListEventLogsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectLogs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listEventLogsWithHttpInfo($account_id, \DocuSign\eSign\Api\ConnectApi\ListEventLogsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listEventLogs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/logs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectLogs',
                '/v2.1/accounts/{accountId}/connect/logs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectLogs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectLogs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listMobileNotifiers
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function listMobileNotifiers($account_id)
    {
        list($response) = $this->listMobileNotifiersWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMobileNotifiersWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2.1/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listUsers
     *
     * Returns users from the configured Connect service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\IntegratedUserInfoList
     */
    public function listUsers($account_id, $connect_id, \DocuSign\eSign\Api\ConnectApi\ListUsersOptions $options = null)
    {
        list($response) = $this->listUsersWithHttpInfo($account_id, $connect_id, $options);
        return $response;
    }

    /**
     * Operation listUsersWithHttpInfo
     *
     * Returns users from the configured Connect service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $connect_id The ID of the custom Connect configuration being accessed.
     * @param  \DocuSign\eSign\Api\ConnectApi\ListUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\IntegratedUserInfoList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUsersWithHttpInfo($account_id, $connect_id, \DocuSign\eSign\Api\ConnectApi\ListUsersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listUsers');
        }
        // verify the required parameter 'connect_id' is set
        if ($connect_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $connect_id when calling listUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/{connectId}/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getEmailSubstring() != 'null') {
                $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
            }
            if ($options->getListIncludedUsers() != 'null') {
                $queryParams['list_included_users'] = $this->apiClient->getSerializer()->toQueryValue($options->getListIncludedUsers());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getUserNameSubstring() != 'null') {
                $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($connect_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "connectId", $connect_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\IntegratedUserInfoList',
                '/v2.1/accounts/{accountId}/connect/{connectId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\IntegratedUserInfoList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\IntegratedUserInfoList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation retryEventForEnvelope
     *
     * Republishes Connect information for the specified envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectFailureResults
     */
    public function retryEventForEnvelope($account_id, $envelope_id)
    {
        list($response) = $this->retryEventForEnvelopeWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation retryEventForEnvelopeWithHttpInfo
     *
     * Republishes Connect information for the specified envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectFailureResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function retryEventForEnvelopeWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling retryEventForEnvelope');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling retryEventForEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectFailureResults',
                '/v2.1/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectFailureResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectFailureResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation retryEventForEnvelopes
     *
     * Republishes Connect information for multiple envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectFailureFilter $connect_failure_filter  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectFailureResults
     */
    public function retryEventForEnvelopes($account_id, $connect_failure_filter = null)
    {
        list($response) = $this->retryEventForEnvelopesWithHttpInfo($account_id, $connect_failure_filter);
        return $response;
    }

    /**
     * Operation retryEventForEnvelopesWithHttpInfo
     *
     * Republishes Connect information for multiple envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectFailureFilter $connect_failure_filter  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectFailureResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function retryEventForEnvelopesWithHttpInfo($account_id, $connect_failure_filter = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling retryEventForEnvelopes');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/envelopes/retry_queue";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_failure_filter)) {
            $_tempBody = $connect_failure_filter;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectFailureResults',
                '/v2.1/accounts/{accountId}/connect/envelopes/retry_queue'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectFailureResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectFailureResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateConfiguration
     *
     * Updates a specified Connect configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectCustomConfiguration
     */
    public function updateConfiguration($account_id, $connect_custom_configuration = null)
    {
        list($response) = $this->updateConfigurationWithHttpInfo($account_id, $connect_custom_configuration);
        return $response;
    }

    /**
     * Operation updateConfigurationWithHttpInfo
     *
     * Updates a specified Connect configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectCustomConfiguration $connect_custom_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectCustomConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConfigurationWithHttpInfo($account_id, $connect_custom_configuration = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_custom_configuration)) {
            $_tempBody = $connect_custom_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectCustomConfiguration',
                '/v2.1/accounts/{accountId}/connect'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectCustomConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectCustomConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateConnectOAuthConfig
     *
     * Updates the existing Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectOAuthConfig $connect_o_auth_config  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConnectOAuthConfig
     */
    public function updateConnectOAuthConfig($account_id, $connect_o_auth_config = null)
    {
        list($response) = $this->updateConnectOAuthConfigWithHttpInfo($account_id, $connect_o_auth_config);
        return $response;
    }

    /**
     * Operation updateConnectOAuthConfigWithHttpInfo
     *
     * Updates the existing Connect OAuth Config for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectOAuthConfig $connect_o_auth_config  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConnectOAuthConfig, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConnectOAuthConfigWithHttpInfo($account_id, $connect_o_auth_config = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateConnectOAuthConfig');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/oauth";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_o_auth_config)) {
            $_tempBody = $connect_o_auth_config;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConnectOAuthConfig',
                '/v2.1/accounts/{accountId}/connect/oauth'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConnectOAuthConfig', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConnectOAuthConfig', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateMobileNotifiers
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\MobileNotifierConfigurationInformation
     */
    public function updateMobileNotifiers($account_id, $mobile_notifier_configuration_information = null)
    {
        list($response) = $this->updateMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information);
        return $response;
    }

    /**
     * Operation updateMobileNotifiersWithHttpInfo
     *
     * Reserved
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\MobileNotifierConfigurationInformation $mobile_notifier_configuration_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\MobileNotifierConfigurationInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateMobileNotifiersWithHttpInfo($account_id, $mobile_notifier_configuration_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateMobileNotifiers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/mobile_notifiers";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($mobile_notifier_configuration_information)) {
            $_tempBody = $mobile_notifier_configuration_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation',
                '/v2.1/accounts/{accountId}/connect/mobile_notifiers'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\MobileNotifierConfigurationInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
