<?php
/**
 * LocalePolicy
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * LocalePolicy Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LocalePolicy implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'localePolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'address_format' => '?string',
        'address_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_region' => '?string',
        'calendar_type' => '?string',
        'calendar_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'culture_name' => '?string',
        'culture_name_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'currency_code' => '?string',
        'currency_code_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'currency_negative_format' => '?string',
        'currency_negative_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'currency_positive_format' => '?string',
        'currency_positive_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'custom_date_format' => '?string',
        'custom_sign_date_format' => '?string',
        'custom_sign_time_format' => '?string',
        'custom_time_format' => '?string',
        'date_format' => '?string',
        'date_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'effective_address_format' => '?string',
        'effective_calendar_type' => '?string',
        'effective_currency_code' => '?string',
        'effective_currency_negative_format' => '?string',
        'effective_currency_positive_format' => '?string',
        'effective_custom_date_format' => '?string',
        'effective_custom_time_format' => '?string',
        'effective_date_format' => '?string',
        'effective_initial_format' => '?string',
        'effective_name_format' => '?string',
        'effective_time_format' => '?string',
        'effective_time_zone' => '?string',
        'initial_format' => '?string',
        'initial_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'name_format' => '?string',
        'name_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_date_format' => '?string',
        'sign_date_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_time_format' => '?string',
        'sign_time_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'time_format' => '?string',
        'time_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'time_zone' => '?string',
        'time_zone_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'address_format' => null,
        'address_format_metadata' => null,
        'allow_region' => null,
        'calendar_type' => null,
        'calendar_type_metadata' => null,
        'culture_name' => null,
        'culture_name_metadata' => null,
        'currency_code' => null,
        'currency_code_metadata' => null,
        'currency_negative_format' => null,
        'currency_negative_format_metadata' => null,
        'currency_positive_format' => null,
        'currency_positive_format_metadata' => null,
        'custom_date_format' => null,
        'custom_sign_date_format' => null,
        'custom_sign_time_format' => null,
        'custom_time_format' => null,
        'date_format' => null,
        'date_format_metadata' => null,
        'effective_address_format' => null,
        'effective_calendar_type' => null,
        'effective_currency_code' => null,
        'effective_currency_negative_format' => null,
        'effective_currency_positive_format' => null,
        'effective_custom_date_format' => null,
        'effective_custom_time_format' => null,
        'effective_date_format' => null,
        'effective_initial_format' => null,
        'effective_name_format' => null,
        'effective_time_format' => null,
        'effective_time_zone' => null,
        'initial_format' => null,
        'initial_format_metadata' => null,
        'name_format' => null,
        'name_format_metadata' => null,
        'sign_date_format' => null,
        'sign_date_format_metadata' => null,
        'sign_time_format' => null,
        'sign_time_format_metadata' => null,
        'time_format' => null,
        'time_format_metadata' => null,
        'time_zone' => null,
        'time_zone_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address_format' => 'addressFormat',
        'address_format_metadata' => 'addressFormatMetadata',
        'allow_region' => 'allowRegion',
        'calendar_type' => 'calendarType',
        'calendar_type_metadata' => 'calendarTypeMetadata',
        'culture_name' => 'cultureName',
        'culture_name_metadata' => 'cultureNameMetadata',
        'currency_code' => 'currencyCode',
        'currency_code_metadata' => 'currencyCodeMetadata',
        'currency_negative_format' => 'currencyNegativeFormat',
        'currency_negative_format_metadata' => 'currencyNegativeFormatMetadata',
        'currency_positive_format' => 'currencyPositiveFormat',
        'currency_positive_format_metadata' => 'currencyPositiveFormatMetadata',
        'custom_date_format' => 'customDateFormat',
        'custom_sign_date_format' => 'customSignDateFormat',
        'custom_sign_time_format' => 'customSignTimeFormat',
        'custom_time_format' => 'customTimeFormat',
        'date_format' => 'dateFormat',
        'date_format_metadata' => 'dateFormatMetadata',
        'effective_address_format' => 'effectiveAddressFormat',
        'effective_calendar_type' => 'effectiveCalendarType',
        'effective_currency_code' => 'effectiveCurrencyCode',
        'effective_currency_negative_format' => 'effectiveCurrencyNegativeFormat',
        'effective_currency_positive_format' => 'effectiveCurrencyPositiveFormat',
        'effective_custom_date_format' => 'effectiveCustomDateFormat',
        'effective_custom_time_format' => 'effectiveCustomTimeFormat',
        'effective_date_format' => 'effectiveDateFormat',
        'effective_initial_format' => 'effectiveInitialFormat',
        'effective_name_format' => 'effectiveNameFormat',
        'effective_time_format' => 'effectiveTimeFormat',
        'effective_time_zone' => 'effectiveTimeZone',
        'initial_format' => 'initialFormat',
        'initial_format_metadata' => 'initialFormatMetadata',
        'name_format' => 'nameFormat',
        'name_format_metadata' => 'nameFormatMetadata',
        'sign_date_format' => 'signDateFormat',
        'sign_date_format_metadata' => 'signDateFormatMetadata',
        'sign_time_format' => 'signTimeFormat',
        'sign_time_format_metadata' => 'signTimeFormatMetadata',
        'time_format' => 'timeFormat',
        'time_format_metadata' => 'timeFormatMetadata',
        'time_zone' => 'timeZone',
        'time_zone_metadata' => 'timeZoneMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address_format' => 'setAddressFormat',
        'address_format_metadata' => 'setAddressFormatMetadata',
        'allow_region' => 'setAllowRegion',
        'calendar_type' => 'setCalendarType',
        'calendar_type_metadata' => 'setCalendarTypeMetadata',
        'culture_name' => 'setCultureName',
        'culture_name_metadata' => 'setCultureNameMetadata',
        'currency_code' => 'setCurrencyCode',
        'currency_code_metadata' => 'setCurrencyCodeMetadata',
        'currency_negative_format' => 'setCurrencyNegativeFormat',
        'currency_negative_format_metadata' => 'setCurrencyNegativeFormatMetadata',
        'currency_positive_format' => 'setCurrencyPositiveFormat',
        'currency_positive_format_metadata' => 'setCurrencyPositiveFormatMetadata',
        'custom_date_format' => 'setCustomDateFormat',
        'custom_sign_date_format' => 'setCustomSignDateFormat',
        'custom_sign_time_format' => 'setCustomSignTimeFormat',
        'custom_time_format' => 'setCustomTimeFormat',
        'date_format' => 'setDateFormat',
        'date_format_metadata' => 'setDateFormatMetadata',
        'effective_address_format' => 'setEffectiveAddressFormat',
        'effective_calendar_type' => 'setEffectiveCalendarType',
        'effective_currency_code' => 'setEffectiveCurrencyCode',
        'effective_currency_negative_format' => 'setEffectiveCurrencyNegativeFormat',
        'effective_currency_positive_format' => 'setEffectiveCurrencyPositiveFormat',
        'effective_custom_date_format' => 'setEffectiveCustomDateFormat',
        'effective_custom_time_format' => 'setEffectiveCustomTimeFormat',
        'effective_date_format' => 'setEffectiveDateFormat',
        'effective_initial_format' => 'setEffectiveInitialFormat',
        'effective_name_format' => 'setEffectiveNameFormat',
        'effective_time_format' => 'setEffectiveTimeFormat',
        'effective_time_zone' => 'setEffectiveTimeZone',
        'initial_format' => 'setInitialFormat',
        'initial_format_metadata' => 'setInitialFormatMetadata',
        'name_format' => 'setNameFormat',
        'name_format_metadata' => 'setNameFormatMetadata',
        'sign_date_format' => 'setSignDateFormat',
        'sign_date_format_metadata' => 'setSignDateFormatMetadata',
        'sign_time_format' => 'setSignTimeFormat',
        'sign_time_format_metadata' => 'setSignTimeFormatMetadata',
        'time_format' => 'setTimeFormat',
        'time_format_metadata' => 'setTimeFormatMetadata',
        'time_zone' => 'setTimeZone',
        'time_zone_metadata' => 'setTimeZoneMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address_format' => 'getAddressFormat',
        'address_format_metadata' => 'getAddressFormatMetadata',
        'allow_region' => 'getAllowRegion',
        'calendar_type' => 'getCalendarType',
        'calendar_type_metadata' => 'getCalendarTypeMetadata',
        'culture_name' => 'getCultureName',
        'culture_name_metadata' => 'getCultureNameMetadata',
        'currency_code' => 'getCurrencyCode',
        'currency_code_metadata' => 'getCurrencyCodeMetadata',
        'currency_negative_format' => 'getCurrencyNegativeFormat',
        'currency_negative_format_metadata' => 'getCurrencyNegativeFormatMetadata',
        'currency_positive_format' => 'getCurrencyPositiveFormat',
        'currency_positive_format_metadata' => 'getCurrencyPositiveFormatMetadata',
        'custom_date_format' => 'getCustomDateFormat',
        'custom_sign_date_format' => 'getCustomSignDateFormat',
        'custom_sign_time_format' => 'getCustomSignTimeFormat',
        'custom_time_format' => 'getCustomTimeFormat',
        'date_format' => 'getDateFormat',
        'date_format_metadata' => 'getDateFormatMetadata',
        'effective_address_format' => 'getEffectiveAddressFormat',
        'effective_calendar_type' => 'getEffectiveCalendarType',
        'effective_currency_code' => 'getEffectiveCurrencyCode',
        'effective_currency_negative_format' => 'getEffectiveCurrencyNegativeFormat',
        'effective_currency_positive_format' => 'getEffectiveCurrencyPositiveFormat',
        'effective_custom_date_format' => 'getEffectiveCustomDateFormat',
        'effective_custom_time_format' => 'getEffectiveCustomTimeFormat',
        'effective_date_format' => 'getEffectiveDateFormat',
        'effective_initial_format' => 'getEffectiveInitialFormat',
        'effective_name_format' => 'getEffectiveNameFormat',
        'effective_time_format' => 'getEffectiveTimeFormat',
        'effective_time_zone' => 'getEffectiveTimeZone',
        'initial_format' => 'getInitialFormat',
        'initial_format_metadata' => 'getInitialFormatMetadata',
        'name_format' => 'getNameFormat',
        'name_format_metadata' => 'getNameFormatMetadata',
        'sign_date_format' => 'getSignDateFormat',
        'sign_date_format_metadata' => 'getSignDateFormatMetadata',
        'sign_time_format' => 'getSignTimeFormat',
        'sign_time_format_metadata' => 'getSignTimeFormatMetadata',
        'time_format' => 'getTimeFormat',
        'time_format_metadata' => 'getTimeFormatMetadata',
        'time_zone' => 'getTimeZone',
        'time_zone_metadata' => 'getTimeZoneMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['address_format'] = isset($data['address_format']) ? $data['address_format'] : null;
        $this->container['address_format_metadata'] = isset($data['address_format_metadata']) ? $data['address_format_metadata'] : null;
        $this->container['allow_region'] = isset($data['allow_region']) ? $data['allow_region'] : null;
        $this->container['calendar_type'] = isset($data['calendar_type']) ? $data['calendar_type'] : null;
        $this->container['calendar_type_metadata'] = isset($data['calendar_type_metadata']) ? $data['calendar_type_metadata'] : null;
        $this->container['culture_name'] = isset($data['culture_name']) ? $data['culture_name'] : null;
        $this->container['culture_name_metadata'] = isset($data['culture_name_metadata']) ? $data['culture_name_metadata'] : null;
        $this->container['currency_code'] = isset($data['currency_code']) ? $data['currency_code'] : null;
        $this->container['currency_code_metadata'] = isset($data['currency_code_metadata']) ? $data['currency_code_metadata'] : null;
        $this->container['currency_negative_format'] = isset($data['currency_negative_format']) ? $data['currency_negative_format'] : null;
        $this->container['currency_negative_format_metadata'] = isset($data['currency_negative_format_metadata']) ? $data['currency_negative_format_metadata'] : null;
        $this->container['currency_positive_format'] = isset($data['currency_positive_format']) ? $data['currency_positive_format'] : null;
        $this->container['currency_positive_format_metadata'] = isset($data['currency_positive_format_metadata']) ? $data['currency_positive_format_metadata'] : null;
        $this->container['custom_date_format'] = isset($data['custom_date_format']) ? $data['custom_date_format'] : null;
        $this->container['custom_sign_date_format'] = isset($data['custom_sign_date_format']) ? $data['custom_sign_date_format'] : null;
        $this->container['custom_sign_time_format'] = isset($data['custom_sign_time_format']) ? $data['custom_sign_time_format'] : null;
        $this->container['custom_time_format'] = isset($data['custom_time_format']) ? $data['custom_time_format'] : null;
        $this->container['date_format'] = isset($data['date_format']) ? $data['date_format'] : null;
        $this->container['date_format_metadata'] = isset($data['date_format_metadata']) ? $data['date_format_metadata'] : null;
        $this->container['effective_address_format'] = isset($data['effective_address_format']) ? $data['effective_address_format'] : null;
        $this->container['effective_calendar_type'] = isset($data['effective_calendar_type']) ? $data['effective_calendar_type'] : null;
        $this->container['effective_currency_code'] = isset($data['effective_currency_code']) ? $data['effective_currency_code'] : null;
        $this->container['effective_currency_negative_format'] = isset($data['effective_currency_negative_format']) ? $data['effective_currency_negative_format'] : null;
        $this->container['effective_currency_positive_format'] = isset($data['effective_currency_positive_format']) ? $data['effective_currency_positive_format'] : null;
        $this->container['effective_custom_date_format'] = isset($data['effective_custom_date_format']) ? $data['effective_custom_date_format'] : null;
        $this->container['effective_custom_time_format'] = isset($data['effective_custom_time_format']) ? $data['effective_custom_time_format'] : null;
        $this->container['effective_date_format'] = isset($data['effective_date_format']) ? $data['effective_date_format'] : null;
        $this->container['effective_initial_format'] = isset($data['effective_initial_format']) ? $data['effective_initial_format'] : null;
        $this->container['effective_name_format'] = isset($data['effective_name_format']) ? $data['effective_name_format'] : null;
        $this->container['effective_time_format'] = isset($data['effective_time_format']) ? $data['effective_time_format'] : null;
        $this->container['effective_time_zone'] = isset($data['effective_time_zone']) ? $data['effective_time_zone'] : null;
        $this->container['initial_format'] = isset($data['initial_format']) ? $data['initial_format'] : null;
        $this->container['initial_format_metadata'] = isset($data['initial_format_metadata']) ? $data['initial_format_metadata'] : null;
        $this->container['name_format'] = isset($data['name_format']) ? $data['name_format'] : null;
        $this->container['name_format_metadata'] = isset($data['name_format_metadata']) ? $data['name_format_metadata'] : null;
        $this->container['sign_date_format'] = isset($data['sign_date_format']) ? $data['sign_date_format'] : null;
        $this->container['sign_date_format_metadata'] = isset($data['sign_date_format_metadata']) ? $data['sign_date_format_metadata'] : null;
        $this->container['sign_time_format'] = isset($data['sign_time_format']) ? $data['sign_time_format'] : null;
        $this->container['sign_time_format_metadata'] = isset($data['sign_time_format_metadata']) ? $data['sign_time_format_metadata'] : null;
        $this->container['time_format'] = isset($data['time_format']) ? $data['time_format'] : null;
        $this->container['time_format_metadata'] = isset($data['time_format_metadata']) ? $data['time_format_metadata'] : null;
        $this->container['time_zone'] = isset($data['time_zone']) ? $data['time_zone'] : null;
        $this->container['time_zone_metadata'] = isset($data['time_zone_metadata']) ? $data['time_zone_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address_format
     *
     * @return ?string
     */
    public function getAddressFormat()
    {
        return $this->container['address_format'];
    }

    /**
     * Sets address_format
     *
     * @param ?string $address_format 
     *
     * @return $this
     */
    public function setAddressFormat($address_format)
    {
        $this->container['address_format'] = $address_format;

        return $this;
    }

    /**
     * Gets address_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAddressFormatMetadata()
    {
        return $this->container['address_format_metadata'];
    }

    /**
     * Sets address_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $address_format_metadata 
     *
     * @return $this
     */
    public function setAddressFormatMetadata($address_format_metadata)
    {
        $this->container['address_format_metadata'] = $address_format_metadata;

        return $this;
    }

    /**
     * Gets allow_region
     *
     * @return ?string
     */
    public function getAllowRegion()
    {
        return $this->container['allow_region'];
    }

    /**
     * Sets allow_region
     *
     * @param ?string $allow_region 
     *
     * @return $this
     */
    public function setAllowRegion($allow_region)
    {
        $this->container['allow_region'] = $allow_region;

        return $this;
    }

    /**
     * Gets calendar_type
     *
     * @return ?string
     */
    public function getCalendarType()
    {
        return $this->container['calendar_type'];
    }

    /**
     * Sets calendar_type
     *
     * @param ?string $calendar_type 
     *
     * @return $this
     */
    public function setCalendarType($calendar_type)
    {
        $this->container['calendar_type'] = $calendar_type;

        return $this;
    }

    /**
     * Gets calendar_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCalendarTypeMetadata()
    {
        return $this->container['calendar_type_metadata'];
    }

    /**
     * Sets calendar_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $calendar_type_metadata 
     *
     * @return $this
     */
    public function setCalendarTypeMetadata($calendar_type_metadata)
    {
        $this->container['calendar_type_metadata'] = $calendar_type_metadata;

        return $this;
    }

    /**
     * Gets culture_name
     *
     * @return ?string
     */
    public function getCultureName()
    {
        return $this->container['culture_name'];
    }

    /**
     * Sets culture_name
     *
     * @param ?string $culture_name 
     *
     * @return $this
     */
    public function setCultureName($culture_name)
    {
        $this->container['culture_name'] = $culture_name;

        return $this;
    }

    /**
     * Gets culture_name_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCultureNameMetadata()
    {
        return $this->container['culture_name_metadata'];
    }

    /**
     * Sets culture_name_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $culture_name_metadata 
     *
     * @return $this
     */
    public function setCultureNameMetadata($culture_name_metadata)
    {
        $this->container['culture_name_metadata'] = $culture_name_metadata;

        return $this;
    }

    /**
     * Gets currency_code
     *
     * @return ?string
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param ?string $currency_code 
     *
     * @return $this
     */
    public function setCurrencyCode($currency_code)
    {
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets currency_code_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCurrencyCodeMetadata()
    {
        return $this->container['currency_code_metadata'];
    }

    /**
     * Sets currency_code_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $currency_code_metadata Metadata that indicates whether the `currencyCode` property is editable.
     *
     * @return $this
     */
    public function setCurrencyCodeMetadata($currency_code_metadata)
    {
        $this->container['currency_code_metadata'] = $currency_code_metadata;

        return $this;
    }

    /**
     * Gets currency_negative_format
     *
     * @return ?string
     */
    public function getCurrencyNegativeFormat()
    {
        return $this->container['currency_negative_format'];
    }

    /**
     * Sets currency_negative_format
     *
     * @param ?string $currency_negative_format 
     *
     * @return $this
     */
    public function setCurrencyNegativeFormat($currency_negative_format)
    {
        $this->container['currency_negative_format'] = $currency_negative_format;

        return $this;
    }

    /**
     * Gets currency_negative_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCurrencyNegativeFormatMetadata()
    {
        return $this->container['currency_negative_format_metadata'];
    }

    /**
     * Sets currency_negative_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $currency_negative_format_metadata 
     *
     * @return $this
     */
    public function setCurrencyNegativeFormatMetadata($currency_negative_format_metadata)
    {
        $this->container['currency_negative_format_metadata'] = $currency_negative_format_metadata;

        return $this;
    }

    /**
     * Gets currency_positive_format
     *
     * @return ?string
     */
    public function getCurrencyPositiveFormat()
    {
        return $this->container['currency_positive_format'];
    }

    /**
     * Sets currency_positive_format
     *
     * @param ?string $currency_positive_format 
     *
     * @return $this
     */
    public function setCurrencyPositiveFormat($currency_positive_format)
    {
        $this->container['currency_positive_format'] = $currency_positive_format;

        return $this;
    }

    /**
     * Gets currency_positive_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCurrencyPositiveFormatMetadata()
    {
        return $this->container['currency_positive_format_metadata'];
    }

    /**
     * Sets currency_positive_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $currency_positive_format_metadata 
     *
     * @return $this
     */
    public function setCurrencyPositiveFormatMetadata($currency_positive_format_metadata)
    {
        $this->container['currency_positive_format_metadata'] = $currency_positive_format_metadata;

        return $this;
    }

    /**
     * Gets custom_date_format
     *
     * @return ?string
     */
    public function getCustomDateFormat()
    {
        return $this->container['custom_date_format'];
    }

    /**
     * Sets custom_date_format
     *
     * @param ?string $custom_date_format 
     *
     * @return $this
     */
    public function setCustomDateFormat($custom_date_format)
    {
        $this->container['custom_date_format'] = $custom_date_format;

        return $this;
    }

    /**
     * Gets custom_sign_date_format
     *
     * @return ?string
     */
    public function getCustomSignDateFormat()
    {
        return $this->container['custom_sign_date_format'];
    }

    /**
     * Sets custom_sign_date_format
     *
     * @param ?string $custom_sign_date_format 
     *
     * @return $this
     */
    public function setCustomSignDateFormat($custom_sign_date_format)
    {
        $this->container['custom_sign_date_format'] = $custom_sign_date_format;

        return $this;
    }

    /**
     * Gets custom_sign_time_format
     *
     * @return ?string
     */
    public function getCustomSignTimeFormat()
    {
        return $this->container['custom_sign_time_format'];
    }

    /**
     * Sets custom_sign_time_format
     *
     * @param ?string $custom_sign_time_format 
     *
     * @return $this
     */
    public function setCustomSignTimeFormat($custom_sign_time_format)
    {
        $this->container['custom_sign_time_format'] = $custom_sign_time_format;

        return $this;
    }

    /**
     * Gets custom_time_format
     *
     * @return ?string
     */
    public function getCustomTimeFormat()
    {
        return $this->container['custom_time_format'];
    }

    /**
     * Sets custom_time_format
     *
     * @param ?string $custom_time_format 
     *
     * @return $this
     */
    public function setCustomTimeFormat($custom_time_format)
    {
        $this->container['custom_time_format'] = $custom_time_format;

        return $this;
    }

    /**
     * Gets date_format
     *
     * @return ?string
     */
    public function getDateFormat()
    {
        return $this->container['date_format'];
    }

    /**
     * Sets date_format
     *
     * @param ?string $date_format 
     *
     * @return $this
     */
    public function setDateFormat($date_format)
    {
        $this->container['date_format'] = $date_format;

        return $this;
    }

    /**
     * Gets date_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDateFormatMetadata()
    {
        return $this->container['date_format_metadata'];
    }

    /**
     * Sets date_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $date_format_metadata 
     *
     * @return $this
     */
    public function setDateFormatMetadata($date_format_metadata)
    {
        $this->container['date_format_metadata'] = $date_format_metadata;

        return $this;
    }

    /**
     * Gets effective_address_format
     *
     * @return ?string
     */
    public function getEffectiveAddressFormat()
    {
        return $this->container['effective_address_format'];
    }

    /**
     * Sets effective_address_format
     *
     * @param ?string $effective_address_format 
     *
     * @return $this
     */
    public function setEffectiveAddressFormat($effective_address_format)
    {
        $this->container['effective_address_format'] = $effective_address_format;

        return $this;
    }

    /**
     * Gets effective_calendar_type
     *
     * @return ?string
     */
    public function getEffectiveCalendarType()
    {
        return $this->container['effective_calendar_type'];
    }

    /**
     * Sets effective_calendar_type
     *
     * @param ?string $effective_calendar_type 
     *
     * @return $this
     */
    public function setEffectiveCalendarType($effective_calendar_type)
    {
        $this->container['effective_calendar_type'] = $effective_calendar_type;

        return $this;
    }

    /**
     * Gets effective_currency_code
     *
     * @return ?string
     */
    public function getEffectiveCurrencyCode()
    {
        return $this->container['effective_currency_code'];
    }

    /**
     * Sets effective_currency_code
     *
     * @param ?string $effective_currency_code 
     *
     * @return $this
     */
    public function setEffectiveCurrencyCode($effective_currency_code)
    {
        $this->container['effective_currency_code'] = $effective_currency_code;

        return $this;
    }

    /**
     * Gets effective_currency_negative_format
     *
     * @return ?string
     */
    public function getEffectiveCurrencyNegativeFormat()
    {
        return $this->container['effective_currency_negative_format'];
    }

    /**
     * Sets effective_currency_negative_format
     *
     * @param ?string $effective_currency_negative_format 
     *
     * @return $this
     */
    public function setEffectiveCurrencyNegativeFormat($effective_currency_negative_format)
    {
        $this->container['effective_currency_negative_format'] = $effective_currency_negative_format;

        return $this;
    }

    /**
     * Gets effective_currency_positive_format
     *
     * @return ?string
     */
    public function getEffectiveCurrencyPositiveFormat()
    {
        return $this->container['effective_currency_positive_format'];
    }

    /**
     * Sets effective_currency_positive_format
     *
     * @param ?string $effective_currency_positive_format 
     *
     * @return $this
     */
    public function setEffectiveCurrencyPositiveFormat($effective_currency_positive_format)
    {
        $this->container['effective_currency_positive_format'] = $effective_currency_positive_format;

        return $this;
    }

    /**
     * Gets effective_custom_date_format
     *
     * @return ?string
     */
    public function getEffectiveCustomDateFormat()
    {
        return $this->container['effective_custom_date_format'];
    }

    /**
     * Sets effective_custom_date_format
     *
     * @param ?string $effective_custom_date_format 
     *
     * @return $this
     */
    public function setEffectiveCustomDateFormat($effective_custom_date_format)
    {
        $this->container['effective_custom_date_format'] = $effective_custom_date_format;

        return $this;
    }

    /**
     * Gets effective_custom_time_format
     *
     * @return ?string
     */
    public function getEffectiveCustomTimeFormat()
    {
        return $this->container['effective_custom_time_format'];
    }

    /**
     * Sets effective_custom_time_format
     *
     * @param ?string $effective_custom_time_format 
     *
     * @return $this
     */
    public function setEffectiveCustomTimeFormat($effective_custom_time_format)
    {
        $this->container['effective_custom_time_format'] = $effective_custom_time_format;

        return $this;
    }

    /**
     * Gets effective_date_format
     *
     * @return ?string
     */
    public function getEffectiveDateFormat()
    {
        return $this->container['effective_date_format'];
    }

    /**
     * Sets effective_date_format
     *
     * @param ?string $effective_date_format 
     *
     * @return $this
     */
    public function setEffectiveDateFormat($effective_date_format)
    {
        $this->container['effective_date_format'] = $effective_date_format;

        return $this;
    }

    /**
     * Gets effective_initial_format
     *
     * @return ?string
     */
    public function getEffectiveInitialFormat()
    {
        return $this->container['effective_initial_format'];
    }

    /**
     * Sets effective_initial_format
     *
     * @param ?string $effective_initial_format 
     *
     * @return $this
     */
    public function setEffectiveInitialFormat($effective_initial_format)
    {
        $this->container['effective_initial_format'] = $effective_initial_format;

        return $this;
    }

    /**
     * Gets effective_name_format
     *
     * @return ?string
     */
    public function getEffectiveNameFormat()
    {
        return $this->container['effective_name_format'];
    }

    /**
     * Sets effective_name_format
     *
     * @param ?string $effective_name_format 
     *
     * @return $this
     */
    public function setEffectiveNameFormat($effective_name_format)
    {
        $this->container['effective_name_format'] = $effective_name_format;

        return $this;
    }

    /**
     * Gets effective_time_format
     *
     * @return ?string
     */
    public function getEffectiveTimeFormat()
    {
        return $this->container['effective_time_format'];
    }

    /**
     * Sets effective_time_format
     *
     * @param ?string $effective_time_format 
     *
     * @return $this
     */
    public function setEffectiveTimeFormat($effective_time_format)
    {
        $this->container['effective_time_format'] = $effective_time_format;

        return $this;
    }

    /**
     * Gets effective_time_zone
     *
     * @return ?string
     */
    public function getEffectiveTimeZone()
    {
        return $this->container['effective_time_zone'];
    }

    /**
     * Sets effective_time_zone
     *
     * @param ?string $effective_time_zone 
     *
     * @return $this
     */
    public function setEffectiveTimeZone($effective_time_zone)
    {
        $this->container['effective_time_zone'] = $effective_time_zone;

        return $this;
    }

    /**
     * Gets initial_format
     *
     * @return ?string
     */
    public function getInitialFormat()
    {
        return $this->container['initial_format'];
    }

    /**
     * Sets initial_format
     *
     * @param ?string $initial_format 
     *
     * @return $this
     */
    public function setInitialFormat($initial_format)
    {
        $this->container['initial_format'] = $initial_format;

        return $this;
    }

    /**
     * Gets initial_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getInitialFormatMetadata()
    {
        return $this->container['initial_format_metadata'];
    }

    /**
     * Sets initial_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $initial_format_metadata 
     *
     * @return $this
     */
    public function setInitialFormatMetadata($initial_format_metadata)
    {
        $this->container['initial_format_metadata'] = $initial_format_metadata;

        return $this;
    }

    /**
     * Gets name_format
     *
     * @return ?string
     */
    public function getNameFormat()
    {
        return $this->container['name_format'];
    }

    /**
     * Sets name_format
     *
     * @param ?string $name_format 
     *
     * @return $this
     */
    public function setNameFormat($name_format)
    {
        $this->container['name_format'] = $name_format;

        return $this;
    }

    /**
     * Gets name_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getNameFormatMetadata()
    {
        return $this->container['name_format_metadata'];
    }

    /**
     * Sets name_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $name_format_metadata 
     *
     * @return $this
     */
    public function setNameFormatMetadata($name_format_metadata)
    {
        $this->container['name_format_metadata'] = $name_format_metadata;

        return $this;
    }

    /**
     * Gets sign_date_format
     *
     * @return ?string
     */
    public function getSignDateFormat()
    {
        return $this->container['sign_date_format'];
    }

    /**
     * Sets sign_date_format
     *
     * @param ?string $sign_date_format 
     *
     * @return $this
     */
    public function setSignDateFormat($sign_date_format)
    {
        $this->container['sign_date_format'] = $sign_date_format;

        return $this;
    }

    /**
     * Gets sign_date_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignDateFormatMetadata()
    {
        return $this->container['sign_date_format_metadata'];
    }

    /**
     * Sets sign_date_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_date_format_metadata Metadata that indicates whether the `signDateFormat` property is editable.
     *
     * @return $this
     */
    public function setSignDateFormatMetadata($sign_date_format_metadata)
    {
        $this->container['sign_date_format_metadata'] = $sign_date_format_metadata;

        return $this;
    }

    /**
     * Gets sign_time_format
     *
     * @return ?string
     */
    public function getSignTimeFormat()
    {
        return $this->container['sign_time_format'];
    }

    /**
     * Sets sign_time_format
     *
     * @param ?string $sign_time_format 
     *
     * @return $this
     */
    public function setSignTimeFormat($sign_time_format)
    {
        $this->container['sign_time_format'] = $sign_time_format;

        return $this;
    }

    /**
     * Gets sign_time_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignTimeFormatMetadata()
    {
        return $this->container['sign_time_format_metadata'];
    }

    /**
     * Sets sign_time_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_time_format_metadata Metadata that indicates whether the `signTimeFormat` property is editable.
     *
     * @return $this
     */
    public function setSignTimeFormatMetadata($sign_time_format_metadata)
    {
        $this->container['sign_time_format_metadata'] = $sign_time_format_metadata;

        return $this;
    }

    /**
     * Gets time_format
     *
     * @return ?string
     */
    public function getTimeFormat()
    {
        return $this->container['time_format'];
    }

    /**
     * Sets time_format
     *
     * @param ?string $time_format 
     *
     * @return $this
     */
    public function setTimeFormat($time_format)
    {
        $this->container['time_format'] = $time_format;

        return $this;
    }

    /**
     * Gets time_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimeFormatMetadata()
    {
        return $this->container['time_format_metadata'];
    }

    /**
     * Sets time_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $time_format_metadata 
     *
     * @return $this
     */
    public function setTimeFormatMetadata($time_format_metadata)
    {
        $this->container['time_format_metadata'] = $time_format_metadata;

        return $this;
    }

    /**
     * Gets time_zone
     *
     * @return ?string
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     *
     * @param ?string $time_zone 
     *
     * @return $this
     */
    public function setTimeZone($time_zone)
    {
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets time_zone_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimeZoneMetadata()
    {
        return $this->container['time_zone_metadata'];
    }

    /**
     * Sets time_zone_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $time_zone_metadata 
     *
     * @return $this
     */
    public function setTimeZoneMetadata($time_zone_metadata)
    {
        $this->container['time_zone_metadata'] = $time_zone_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

