<?php
declare(strict_types=1);

/**
 * PowerFormsApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\PowerFormsApi;


/**
 * GetPowerFormDataOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPowerFormDataOptions
{
    /**
      * $data_layout 
      * @var ?string
      */
    protected ?string $data_layout = null;

    /**
     * Gets data_layout
     *
     * @return ?string
     */
    public function getDataLayout(): ?string
    {
        return $this->data_layout;
    }

    /**
     * Sets data_layout
     * @param ?string $data_layout 
     *
     * @return self
     */
    public function setDataLayout(?string $data_layout): self
    {
        $this->data_layout = $data_layout;
        return $this;
    }
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}


/**
 * ListPowerFormSendersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListPowerFormSendersOptions
{
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * ListPowerFormsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListPowerFormsOptions
{
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $order 
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order 
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by 
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by 
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_fields 
      * @var ?string
      */
    protected ?string $search_fields = null;

    /**
     * Gets search_fields
     *
     * @return ?string
     */
    public function getSearchFields(): ?string
    {
        return $this->search_fields;
    }

    /**
     * Sets search_fields
     * @param ?string $search_fields 
     *
     * @return self
     */
    public function setSearchFields(?string $search_fields): self
    {
        $this->search_fields = $search_fields;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * PowerFormsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PowerFormsApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createPowerForm
     *
     * Creates a new PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PowerForm $power_form  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerForm
     */
    public function createPowerForm($account_id, $power_form = null)
    {
        list($response) = $this->createPowerFormWithHttpInfo($account_id, $power_form);
        return $response;
    }

    /**
     * Operation createPowerFormWithHttpInfo
     *
     * Creates a new PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PowerForm $power_form  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerForm, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPowerFormWithHttpInfo($account_id, $power_form = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createPowerForm');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($power_form)) {
            $_tempBody = $power_form;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerForm',
                '/v2.1/accounts/{accountId}/powerforms'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerForm', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerForm', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletePowerForm
     *
     * Delete a PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deletePowerForm($account_id, $power_form_id)
    {
        list($response) = $this->deletePowerFormWithHttpInfo($account_id, $power_form_id);
        return $response;
    }

    /**
     * Operation deletePowerFormWithHttpInfo
     *
     * Delete a PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePowerFormWithHttpInfo($account_id, $power_form_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deletePowerForm');
        }
        // verify the required parameter 'power_form_id' is set
        if ($power_form_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $power_form_id when calling deletePowerForm');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms/{powerFormId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($power_form_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "powerFormId", $power_form_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/powerforms/{powerFormId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletePowerForms
     *
     * Deletes one or more PowerForms
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PowerFormsRequest $power_forms_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerFormsResponse
     */
    public function deletePowerForms($account_id, $power_forms_request = null)
    {
        list($response) = $this->deletePowerFormsWithHttpInfo($account_id, $power_forms_request);
        return $response;
    }

    /**
     * Operation deletePowerFormsWithHttpInfo
     *
     * Deletes one or more PowerForms
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PowerFormsRequest $power_forms_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerFormsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePowerFormsWithHttpInfo($account_id, $power_forms_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deletePowerForms');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($power_forms_request)) {
            $_tempBody = $power_forms_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerFormsResponse',
                '/v2.1/accounts/{accountId}/powerforms'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerFormsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerFormsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPowerForm
     *
     * Returns a single PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerForm
     */
    public function getPowerForm($account_id, $power_form_id)
    {
        list($response) = $this->getPowerFormWithHttpInfo($account_id, $power_form_id);
        return $response;
    }

    /**
     * Operation getPowerFormWithHttpInfo
     *
     * Returns a single PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerForm, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPowerFormWithHttpInfo($account_id, $power_form_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPowerForm');
        }
        // verify the required parameter 'power_form_id' is set
        if ($power_form_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $power_form_id when calling getPowerForm');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms/{powerFormId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($power_form_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "powerFormId", $power_form_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerForm',
                '/v2.1/accounts/{accountId}/powerforms/{powerFormId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerForm', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerForm', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPowerFormData
     *
     * Returns the form data associated with the usage of a PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     * @param  \DocuSign\eSign\Api\PowerFormsApi\GetPowerFormDataOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerFormsFormDataResponse
     */
    public function getPowerFormData($account_id, $power_form_id, \DocuSign\eSign\Api\PowerFormsApi\GetPowerFormDataOptions $options = null)
    {
        list($response) = $this->getPowerFormDataWithHttpInfo($account_id, $power_form_id, $options);
        return $response;
    }

    /**
     * Operation getPowerFormDataWithHttpInfo
     *
     * Returns the form data associated with the usage of a PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     * @param  \DocuSign\eSign\Api\PowerFormsApi\GetPowerFormDataOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerFormsFormDataResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPowerFormDataWithHttpInfo($account_id, $power_form_id, \DocuSign\eSign\Api\PowerFormsApi\GetPowerFormDataOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPowerFormData');
        }
        // verify the required parameter 'power_form_id' is set
        if ($power_form_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $power_form_id when calling getPowerFormData');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms/{powerFormId}/form_data";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDataLayout() != 'null') {
                $queryParams['data_layout'] = $this->apiClient->getSerializer()->toQueryValue($options->getDataLayout());
            }
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($power_form_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "powerFormId", $power_form_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerFormsFormDataResponse',
                '/v2.1/accounts/{accountId}/powerforms/{powerFormId}/form_data'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerFormsFormDataResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerFormsFormDataResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPowerFormSenders
     *
     * Returns the list of PowerForms available to the user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormSendersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerFormSendersResponse
     */
    public function listPowerFormSenders($account_id, \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormSendersOptions $options = null)
    {
        list($response) = $this->listPowerFormSendersWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPowerFormSendersWithHttpInfo
     *
     * Returns the list of PowerForms available to the user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormSendersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerFormSendersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPowerFormSendersWithHttpInfo($account_id, \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormSendersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPowerFormSenders');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms/senders";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerFormSendersResponse',
                '/v2.1/accounts/{accountId}/powerforms/senders'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerFormSendersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerFormSendersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPowerForms
     *
     * Returns the list of PowerForms available to the user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerFormsResponse
     */
    public function listPowerForms($account_id, \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormsOptions $options = null)
    {
        list($response) = $this->listPowerFormsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPowerFormsWithHttpInfo
     *
     * Returns the list of PowerForms available to the user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerFormsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPowerFormsWithHttpInfo($account_id, \DocuSign\eSign\Api\PowerFormsApi\ListPowerFormsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPowerForms');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getSearchFields() != 'null') {
                $queryParams['search_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchFields());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerFormsResponse',
                '/v2.1/accounts/{accountId}/powerforms'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerFormsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerFormsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePowerForm
     *
     * Creates a new PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     * @param \DocuSign\eSign\Model\PowerForm $power_form  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PowerForm
     */
    public function updatePowerForm($account_id, $power_form_id, $power_form = null)
    {
        list($response) = $this->updatePowerFormWithHttpInfo($account_id, $power_form_id, $power_form);
        return $response;
    }

    /**
     * Operation updatePowerFormWithHttpInfo
     *
     * Creates a new PowerForm.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $power_form_id 
     * @param \DocuSign\eSign\Model\PowerForm $power_form  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PowerForm, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePowerFormWithHttpInfo($account_id, $power_form_id, $power_form = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePowerForm');
        }
        // verify the required parameter 'power_form_id' is set
        if ($power_form_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $power_form_id when calling updatePowerForm');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/powerforms/{powerFormId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($power_form_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "powerFormId", $power_form_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($power_form)) {
            $_tempBody = $power_form;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PowerForm',
                '/v2.1/accounts/{accountId}/powerforms/{powerFormId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PowerForm', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PowerForm', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
