<?php
$config  = new \Config\App();
$appName = $config->appName . " - Image Generations";
include('header.php');
?>

<main>
  <div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row m-1">
      <div class="col-12">
        <h4 class="main-title">Image Generations</h4>
        <span>Generate AI-based Images for your Calendar Plans.</span>
      </div>
    </div>

    <!-- Table -->
    <div class="row">
      <div class="col-12">
        <div class="card">
          <div class="card-header">
            <form method="get" class="d-inline-block">
              <input
                type="month"
                name="month"
                id="month"
                class="form-control"
                value="<?= esc($_GET['month'] ?? date('Y-m')) ?>"
                onchange="this.form.submit()"
              >
            </form>
          </div>

          <div class="card-body px-0">
            <div class="table-responsive app-scroll app-datatable-default product-list-table">
              <table class="table-sm display align-middle" id="product-Listtable">
                <thead>
                  <tr>
                    <th>Image – Title</th>
                    <th>Description</th>
                    <th>Company</th>
                    <th>Post Date</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($calendar_plans as $plan): ?>
                  <tr>
                    <!-- Image + Title -->
                    <td>
                      <div class="d-flex align-items-center">
                        <?php if ($plan['image']): ?>
                          <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                            <img
                              alt=""
                              class="img-fluid"
                              src="<?= base_url('uploads/images/' . $plan['image']) ?>"
                            >
                          </div>
                        <?php endif; ?>
                        <span class="fw-medium">
                          <?= esc(implode(' ', array_slice(explode(' ', strip_tags($plan['title'])), 0, 3))) ?>
                          <?= str_word_count($plan['title']) > 3 ? '…' : '' ?>
                        </span>
                      </div>
                    </td>

                    <!-- Description -->
                    <td>
                      <?= esc(implode(' ', array_slice(explode(' ', strip_tags($plan['description'])), 0, 4))) ?>
                      <?= str_word_count($plan['description']) > 4 ? '…' : '' ?>
                    </td>

                    <!-- Company -->
                    <td><?= esc($plan['company_name']) ?></td>

                    <!-- Post Date -->
                    <td><?= esc(date('d-m-Y', strtotime($plan['date']))) ?></td>

                    <!-- Status -->
                    <td class="status-cell">
                      <?php if ($plan['plan_status'] === 'Scheduled' && ! empty($plan['scheduled_at'])): ?>
                      <span class="badge text-light-secondary">
                        Scheduled at <?= date('H:i', strtotime($plan['scheduled_at'])) ?>
                        </span>
                      <?php else: ?>
                        <span class="badge text-light-secondary">
                          <?= esc($plan['plan_status']) ?>
                        </span>
                      <?php endif; ?>
                    </td>

                    <!-- Actions -->
                    <?php $hasImage = ! empty($plan['image']); ?>
                    <td class="d-flex gap-2 flex-nowrap">
                      <a
                        href="<?= base_url("home/edit_plan/{$plan['id']}") ?>"
                        class="btn btn-light-success icon-btn b-r-4"
                        title="Edit Content"
                      >
                        <i class="ti ti-edit text-success"></i>
                      </a>

                      <a
                        href="<?= base_url("home/create_post/{$plan['id']}") ?>"
                        class="btn btn-light-primary icon-btn b-r-4"
                        title="Generate Image"
                      >
                        <i class="ti ti-photo text-primary"></i>
                      </a>

                      <!-- Schedule button opens modal -->
                      <button
                        type="button"
                        class="btn btn-light-warning icon-btn b-r-4 schedule-btn"
                        data-plan-id="<?= esc($plan['id']) ?>"
                        data-bs-toggle="modal"
                        data-bs-target="#scheduleModal"
                        <?= ! $hasImage || $plan['plan_status'] === 'Posted' ? 'disabled' : '' ?>
                        title="Schedule"
                      >
                        <i class="ti ti-calendar-event <?= $plan['plan_status'] === 'Posted' ? 'text-secondary' : 'text-warning' ?>"></i>
                      </button>

                      <button
                        type="button"
                        class="btn btn-light-info icon-btn b-r-4 post-btn"
                        data-plan-id="<?= esc($plan['id']) ?>"
                        <?= ! $hasImage || $plan['plan_status'] === 'Posted' ? 'disabled' : '' ?>
                        title="Post"
                      >
                        <i class="ti ti-send text-info"></i>
                      </button>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>

              <?php if (empty($calendar_plans)): ?>
              <div class="text-center p-4">
                <em>No calendar plans found for this month.</em>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Schedule Time Modal -->
  <div
    class="modal fade"
    id="scheduleModal"
    tabindex="-1"
    aria-labelledby="scheduleModalLabel"
    aria-hidden="true"
  >
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="scheduleModalLabel">Select Time</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input
            type="time"
            id="scheduleTimeInput"
            class="form-control"
            value="09:00"
          >
        </div>
        <div class="modal-footer">
          <button
            type="button"
            class="btn btn-secondary"
            data-bs-dismiss="modal"
          >Cancel</button>
          <button
            type="button"
            class="btn btn-primary"
            id="confirmScheduleBtn"
          >Schedule</button>
        </div>
      </div>
    </div>
  </div>
</main>

<!-- Toast container (hidden by default) -->
<div class="position-fixed top-0 end-0 p-3" style="z-index: 1100;">
  <div id="scheduleToast" class="toast align-items-center text-white bg-primary border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body">
        <!-- message will be injected here -->
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

<script>
// 1) Capture plan_id when modal opens via Bootstrap event
let currentPlanId = null;
const scheduleModalEl = document.getElementById('scheduleModal');
scheduleModalEl.addEventListener('show.bs.modal', event => {
  const btn = event.relatedTarget; // the button that opened it
  currentPlanId = btn.getAttribute('data-plan-id');
  document.getElementById('scheduleTimeInput').value = '09:00';
});

// 2) On clicking Confirm, send AJAX and update UI
document.getElementById('confirmScheduleBtn').addEventListener('click', async () => {
  const time = document.getElementById('scheduleTimeInput').value;
  if (!time) {
    // You can leave alert() here or show a warning toast instead
    alert('Please select a time.');
    return;
  }

  const form = new FormData();
  form.append('plan_id', currentPlanId);
  form.append('scheduled_at', time);

  try {
    const res  = await fetch('<?= base_url('home/scheduleSocialPost') ?>', {
      method: 'POST',
      headers: { 'X-Requested-With': 'XMLHttpRequest' },
      body: form
    });
    const json = await res.json();

    if (json.success) {
      // 1) Update the table UI
      const btn = document.querySelector(`.schedule-btn[data-plan-id="${currentPlanId}"]`);
      const row = btn.closest('tr');
      row.querySelector('.status-cell .badge').textContent = `Scheduled at ${time}`;
      // 2) Hide modal
      bootstrap.Modal.getInstance(scheduleModalEl).hide();

      // 3) Show toast instead of alert
      const toastEl = document.getElementById('scheduleToast');
      toastEl.querySelector('.toast-body').textContent = `${json.message}Post Scheduled at ${time}`;
      const bsToast = new bootstrap.Toast(toastEl, { delay: 4000 });
      bsToast.show();
    } else {
      // you can show an error toast similarly, or fallback to alert
      alert(`❌ Error: ${json.error || 'Unknown error'}`);
    }
  } catch (err) {
    console.error(err);
    alert('❌ Network error, could not schedule.');
  }
});

// 3) Post-now handler unchanged
document.querySelectorAll('.post-btn').forEach(btn => {
  btn.addEventListener('click', async () => {
    const planId = btn.dataset.planId;
    const icon   = btn.querySelector('i');
    const scheduleBtn = document.querySelector(`.schedule-btn[data-plan-id="${planId}"]`);
    const row = btn.closest('tr');
    const statusBadge = row.querySelector('.status-cell .badge');

    // 1) Disable "Post" & "Schedule" buttons, show spinner
    btn.disabled = true;
    if (scheduleBtn) scheduleBtn.disabled = true;
    icon.classList.remove('ti-send', 'text-info');
    icon.classList.add('ti-loader', 'ti-spin', 'text-info');

    try {
      const form = new FormData();
      form.append('plan_id', planId);

      const res  = await fetch('<?= base_url('home/postToSocialNow') ?>', {
        method: 'POST',
        headers: { 'X-Requested-With': 'XMLHttpRequest' },
        body: form
      });
      const json = await res.json();

      if (json.success) {
        // 2) On success: update icon, status text (leave buttons disabled)
        icon.classList.remove('ti-loader', 'ti-spin', 'text-info');
        icon.classList.add('ti-send', 'text-secondary');
        if (statusBadge) statusBadge.textContent = 'Posted';

        // Build and show message
        let msg = json.message || 'Posted successfully';
        if (json.post_id.instagram_post_id) {
          msg += `\nInstagram ID: ${json.post_id.instagram_post_id}`;
        }
        if (json.post_id.facebook_post_id) {
          msg += `\nFacebook ID: ${json.post_id.facebook_post_id}`;
        }
        alert('✅ ' + msg);
      } else {
        throw new Error(json.error || 'Error posting');
      }
    } catch (err) {
      // 3) On error: revert everything
      btn.disabled = false;
      if (scheduleBtn) scheduleBtn.disabled = false;
      icon.classList.remove('ti-loader', 'ti-spin', 'text-info');
      icon.classList.add('ti-send', 'text-info');
      console.error(err);
      alert('❌ ' + err.message);
    }
  });
});
</script>

<?php include('footer.php'); ?>
