<?php
$config   = new \Config\App();
$appName  = $config->appName . " - Edit Calendar Plan";
include('header.php');
?>

<main>
  <div class="container-fluid">
    <div class="row m-1">
      <div class="col-12">
        <h4 class="main-title">Edit Calendar</h4>
        <span>Edit your Calendar Plan.</span>
      </div>
    </div>

    <div class="col-xl-12">
      <div class="card add-blog">
        <div class="card-header">
          <h5>Modify Calendar Plan</h5>
        </div>
        <div class="card-body">
          <form class="app-form" action="<?= base_url('home/update_plan'); ?>" method="post">
            <?= csrf_field(); ?>
            <div class="row">
<input type="hidden" name="id" value="<?= esc($plan->id); ?>"/>
                <div class="col-md-2">
                  <div class="form-floating mb-3">
                    <input type="date" name="date" class="form-control" id="date"
                           value="<?= esc($plan->date); ?>" readonly> 
                    <label for="date">Post Date</label>
                  </div>
                </div>
                
                <div class="col-md-4">
                  <div class="form-floating mb-3">
                    <input type="text" name="title" class="form-control" id="title"
                           placeholder="Post Title" value="<?= esc($plan->title); ?>" readonly>
                    <label for="title">Post Title</label>
                  </div>
                </div>
                
                
                <div class="col-md-6">
                  <div class="form-floating mb-3">
                    <input type="text" name="description" class="form-control" id="description"
                           value="<?= esc($plan->description); ?>" readonly> 
                    <label for="description">Short Description</label>
                  </div>
                </div>
                
                <div class="col-md-6">
                  <div class="form-floating mb-3">
                    <textarea name="designer_brief" class="form-control" style="height: 120px"
                              placeholder="Brief for Designer"><?= esc($plan->designer_brief); ?></textarea>
                    <label for="designer_brief">Designer Brief</label>
                  </div>
                </div>
                
                <div class="col-md-6">
                  <div class="form-floating mb-3">
                    <textarea name="caption" class="form-control" style="height: 120px"
                              placeholder="Caption for Post"><?= esc($plan->caption); ?></textarea>
                    <label for="caption">Post Caption</label>
                  </div>
                </div>


              <div class="col-md-6">
                <div class="form-floating mb-3">
                  <textarea name="content" class="form-control" id="content" style="height: 120px"
                            placeholder="Content"><?= esc($plan->content); ?></textarea>
                  <label for="content">Main Content</label>
                </div>
              </div>

              <div class="col-12 ">
                <div class="text-start">
                  <button type="submit" class="btn btn-primary">Update Plan</button>
                </div>
              </div>

            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</main>

<?php include('footer.php'); ?>
