<?php
// View: app/Views/calendar_create.php
$config   = new \Config\App();
$appName  = $config->appName . " - Create Calendar Plan";
include('header.php');
?>

<style>
.photos-container {
    display: grid;
    grid-template-columns: 1fr 1fr 1fr;
    gap: 1rem;
}
</style>

<main>
  <div class="container-fluid">
    <!-- Breadcrumb -->
    <div class="row m-1">
      <div class="col-12">
        <h4 class="main-title">
          Create Post for <?= esc($company['name']) ?>
        </h4>
        <span>Create an AI-generated Image.</span>
      </div>
    </div>


<div class="row position-relative">
  <!-- Left: Calendar Plan table -->
  <div class="col-lg-8 col-xxl-8 box-col-7">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Post Creation</h5>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="photos-container" id="image-gallery">
            <?php if (!empty($images)): ?>
              <?php foreach ($images as $img): ?>
                <div class="img-box mb-3 p-2">
                  <a class="glightbox" data-glightbox="type: image; zoomable: true;" href="<?= base_url() ?>uploads/images/<?= esc($img['image']) ?>">
                    <img src="<?= base_url() ?>uploads/images/<?= esc($img['image']) ?>" alt="AI Image" class="img-fluid rounded w-100">
                  </a>
                  <?php if ($plans['image'] === $img['image']): ?>
                    <button class="btn btn-sm btn-outline-secondary mt-2 w-100" disabled>Using</button>
                  <?php else: ?>
                    <button class="btn btn-sm btn-outline-primary mt-2 w-100" onclick="useImage('<?= esc($img['image']) ?>')">Use This</button>
                  <?php endif; ?>
                  <button class="btn btn-sm btn-outline-secondary mt-1 w-100 modify-btn" data-image="<?= esc($img['image']) ?>" onclick="toggleModify(this)">Modify This</button>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <div>No AI images generated yet.</div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Right: Chat UI -->
  <div class="col-lg-4 col-xxl-4 box-col-5">
    <div class="card chat-container-content-box">
      <div class="card-header">
        <div class="chat-header d-flex align-items-center">
          <div class="d-lg-none">
            <a class="me-3 toggle-btn" role="button">
              <i class="ti ti-align-justified"></i>
            </a>
          </div>
          <span class="profileimg h-45 w-45 d-flex-center b-r-50 bg-light position-relative">
            <img src="<?= base_url('assets/assets/images/avtar/14.png') ?>" class="img-fluid b-r-50" alt="">
            <span class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
          </span>
          <div class="flex-grow-1 ps-2 pe-2">
            <div class="fs-6">You</div>
            <div class="text-muted f-s-12 text-success">Online</div>
          </div>
        </div>
      </div>

      <div class="card-body chat-body">
        <div class="chat-container" id="chat-container">
          <?php foreach ($chats as $c): ?>
            <div class="position-relative">
              <?php if ($c['role'] === 'user'): ?>
                <div class="chat-box-right">
                  <p class="chat-text"><?= esc($c['message']) ?></p>
                </div>
              <?php else: ?>
                <div class="chat-box">
                  <p class="chat-text"><?= esc($c['message']) ?></p>
                </div>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>

      <div class="card-footer">
        <?php if (empty($plans)): ?>
          <button id="generate-plan" class="btn btn-primary w-100 mb-2">Create Plan</button>
        <?php endif; ?>

        <div id="chat-input-container" <?= empty($plans) ? 'style="display:none"' : '' ?> >
          <form id="chat-form" class="d-flex">
            <input type="hidden" name="plan_id" value="<?= esc($plans['id'] ?? '') ?>">
            <input type="hidden" name="image_url" id="image-url-input" value="">
            <div class="input-group w-100">
              <input id="msg-input" name="message" class="form-control" placeholder="Type a message…" autocomplete="off" required>
              <button type="submit" class="btn btn-light-primary ms-2">Send</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>


  </div>
</main>

<script>
const chatForm = document.getElementById('chat-form');
const chatContainer = document.getElementById('chat-container');
const imageGallery = document.getElementById('image-gallery');
let currentModifyImage = null;

chatForm.addEventListener('submit', async e => {
  e.preventDefault();
  const formData = new FormData(chatForm);
  const message = formData.get('message') || '';

  chatContainer.insertAdjacentHTML('beforeend', `
    <div class="position-relative">
      <div class="chat-box-right"><p class="chat-text">${message}</p></div>
    </div>
  `);
  chatContainer.scrollTop = chatContainer.scrollHeight;

  if (currentModifyImage) {
    formData.append('image_url', currentModifyImage);
  }

  await fetch('<?= site_url('home/saveChatMessage') ?>', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ plan_id: formData.get('plan_id'), message, role: 'user' })
  });

  chatForm.reset();
  chatForm.querySelector('input[name="message"]').placeholder = 'Type a message…';

  const ph = document.createElement('div');
  ph.innerHTML = `<div class="chat-box placeholder-glow"><span class="placeholder col-6"></span></div>`;
  chatContainer.appendChild(ph);

  const res = await fetch('<?= site_url('home/generateCalendarImage') ?>', { method: 'POST', body: formData });
  const json = await res.json();
  ph.remove();

  if (json.success) {
    chatContainer.insertAdjacentHTML('beforeend', `
      <div class="chat-box"><p class="chat-text">${json.ai_reply}</p></div>
    `);
    chatContainer.scrollTop = chatContainer.scrollHeight;

    imageGallery.insertAdjacentHTML('afterbegin', `
      <div class="img-box mb-3 p-2">
        <a class="glightbox" data-glightbox="type: image; zoomable: true;" href="${json.image_url}">
          <img src="${json.image_url}" class="img-fluid rounded w-100">
        </a>
        <button class="btn btn-sm btn-outline-primary mt-2 w-100" onclick="useImage('${json.image_url}')">Use This</button>
        <button class="btn btn-sm btn-outline-secondary mt-1 w-100 modify-btn" data-image="${json.image_url}" onclick="toggleModify(this)">Modify This</button>
      </div>
    `);
    currentModifyImage = null;
  } else {
    alert(json.error || 'Something went wrong');
  }
});

async function useImage(imageUrl) {
  const planId = document.querySelector('input[name="plan_id"]').value;
  const res = await fetch('<?= site_url('home/update_plan_image') ?>', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ plan_id: planId, image_url: imageUrl })
  });
  const json = await res.json();
  alert(json.success ? 'Image saved to calendar plan.' : json.error || 'Failed to save image.');
}

function toggleModify(button) {
  const imageUrl = button.dataset.image;
  const input = chatForm.querySelector('input[name="message"]');
  const hiddenInput = document.getElementById('image-url-input');

  if (hiddenInput.value === imageUrl) {
    hiddenInput.value = "";
    button.textContent = "Modify This";
    button.classList.remove("btn-warning");
    button.classList.add("btn-outline-secondary");
  } else {
    document.querySelectorAll('.modify-btn').forEach(btn => {
      btn.textContent = "Modify This";
      btn.classList.remove("btn-warning");
      btn.classList.add("btn-outline-secondary");
    });
    hiddenInput.value = imageUrl;
    button.textContent = "Modifying...";
    button.classList.remove("btn-outline-secondary");
    button.classList.add("btn-warning");
    input.focus();
  }
}
</script>

<?php include('footer.php'); ?>
