<?php
$config  = new \Config\App();
$appName = $config->appName . " - Calendar Plans";
include('header.php');
?>
<?php
// Build a map: company_id → colors (the CSS color string)
$companyColors = array_column($accounts, 'colors', 'id');
?>
<main>
  <div class="container-fluid">

    <!-- Create Plan dropdown -->
    <div class="row m-1">
      <div class="col-12 text-end">
        <?php if (count($accounts) > 0): ?>
          <div class="dropdown">
            <button class="btn btn-primary" data-bs-toggle="dropdown">
              <i class="iconoir-plus fs-5"></i> Create Plan
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
              <?php foreach ($accounts as $acct): ?>
                <li>
                  <a class="dropdown-item"
                     href="<?= site_url("home/create_plan/{$acct['id']}") ?>">
                    <?= esc($acct['name']) ?>
                  </a>
                </li>
              <?php endforeach ?>
            </ul>
          </div>
        <?php endif ?>
      </div>
    </div>

    <!-- FullCalendar -->
    <div class="row m-1">
      <div class="col-12">
        <div class="card">
          <div class="card-body">
            <div id="calendar"></div>
          </div>
        </div>
      </div>
    </div>

  </div>
</main>
<script>
document.addEventListener('DOMContentLoaded', function() {
  var calendarEl    = document.getElementById('calendar');
  var companyColors = <?= json_encode($companyColors, JSON_UNESCAPED_SLASHES) ?>;

  var calendarEvents = <?= json_encode(array_map(function($p) use ($companyColors) {
    return [
      'id'      => (int)$p['id'],
      'title'   => $p['title'],
      'start'   => date('Y-m-d', strtotime($p['date'])),
      'allDay'  => true,
      'color'   => $companyColors[$p['company_id']] ?? '#888888',
      'url'     => site_url("home/view_plan/{$p['id']}")
    ];
  }, $plans), JSON_UNESCAPED_SLASHES) ?>;

  var calendar = new FullCalendar.Calendar(calendarEl, {
    initialView:  'dayGridMonth',
    navLinks:     true,
    editable:     false,
    dayMaxEvents: true,
    headerToolbar:{
      left:  'prev,next today',
      center:'title',
      right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
    },
    events: calendarEvents,
    eventClick: function(info) {
      info.jsEvent.preventDefault();
      if (info.event.url) {
        window.location.href = info.event.url;
      }
    }
  });

  calendar.render();
});
</script>
<?php include('footer.php') ?>