<?php
$config   = new \Config\App();
$appName  = $config->appName . " - Accounts";
include('header.php');
?>

<style>
    .logo-preview {
        max-height: 100px;
        height: 48px;
        position: absolute;
        top: -8px;
        right: -0px;
        border-radius: 10px;
    }
</style>

<main>
  <div class="container-fluid">
    <!-- Breadcrumb start -->
    <div class="row m-1">
      <div class="col-12">
        <h4 class="main-title">Company Profiles</h4>
        <ul class="app-line-breadcrumbs mb-3">
          <li>
            <a class="f-s-14 f-w-500" href="#">
              <span>Manage your Company Profiles and API keys.</span>
            </a>
          </li>
        </ul>
      </div>
    </div>
    <!-- Breadcrumb end -->

    <div class="row">
      <!-- Sidebar tabs -->
      <div class="col-lg-4 col-xxl-3">
        <div class="card">
          <div class="card-header"><h5>Accounts</h5></div>
          <div class="card-body">
            <div class="vertical-tab setting-tab">
              <ul class="nav nav-tabs tab-light-primary" id="companyTabs" role="tablist">
                <li class="nav-item mb-2">
                  <button class="btn btn-sm btn-outline-primary w-100 mb-2" id="addCompanyBtn" type="button">
                    <i class="ph-bold ph-plus-circle pe-1"></i> Add Company
                  </button>
                </li>
                <?php $firstTab = true; ?>
                <?php foreach($accounts as $acct): ?>
                  <li class="nav-item" role="presentation">
                    <button
                      class="nav-link <?= $firstTab ? 'active' : '' ?>"
                      id="tab-<?= $acct['id'] ?>"
                      data-bs-toggle="tab"
                      data-bs-target="#panel-<?= $acct['id'] ?>"
                      type="button"
                      role="tab"
                    ><?= esc($acct['name']) ?></button>
                  </li>
                  <?php $firstTab = false; ?>
                <?php endforeach; ?>
              </ul>
            </div>
          </div>
        </div>
      </div>

      <!-- Tab panes -->
      <div class="col-lg-8 col-xxl-9">
        <div class="tab-content" id="companyContent">
          <?php $firstPane = true; ?>
          <?php foreach($accounts as $acct):
            $goals = !empty($acct['goals']) ? explode(',', $acct['goals']) : [];
          ?>
            <div
              class="tab-pane fade <?= $firstPane ? 'show active' : '' ?>"
              id="panel-<?= $acct['id'] ?>"
              role="tabpanel"
            >
              <div class="card p-4">
                <form class="app-form"
                      method="post"
                      action="<?= site_url('home/updatecompany') ?>"
                      enctype="multipart/form-data">
                  <input type="hidden" name="id" value="<?= esc($acct['id']) ?>">

                  <!-- Company Details -->
                  <div class="row">
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Business Name</label>
                        <input class="form-control" name="name" value="<?= esc($acct['name']) ?>" type="text" placeholder="Your company name" required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Industry / Niche</label>
                        <input class="form-control" name="industry" value="<?= esc($acct['industry']) ?>" type="text" placeholder="e.g., Real Estate, Restaurant" required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Upload Logo</label>
                        <div class="position-relative">
                          <input class="form-control" name="logo" type="file" accept="image/*" onchange="previewLogo(event)">
                          <img class="mt-2 img-fluid logo-preview"
                               src="<?= !empty($acct['logo']) ? base_url($acct['logo']) : '' ?>"
                               style="<?= empty($acct['logo']) ? 'display:none;' : '' ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Preferred Brand Colors / Style</label>
                        <input class="form-control" name="colors" value="<?= esc($acct['colors']) ?>" type="text" placeholder="e.g., Blue and White, Minimal, Bold"  required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Location</label>
                        <input class="form-control" name="location" value="<?= esc($acct['location']) ?>" type="text" placeholder="City & Country"  required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Target Audience</label>
                        <input class="form-control" name="audience" value="<?= esc($acct['audience']) ?>" type="text" placeholder="e.g., college students, professionals" type="text" required>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <label class="form-label">What do you want to increase?</label>
                      <div class="mb-3">
                        <?php foreach(['Social Media Reach','Walk-ins / Footfall','Online Leads','Brand Awareness'] as $g): ?>
                          <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" name="goals[]" value="<?= $g ?>"
                                   <?= in_array($g, $goals) ? 'checked' : '' ?>>
                            <label class="form-check-label"><?= $g ?></label>
                          </div>
                        <?php endforeach; ?>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">Your Competitors (Links)</label>
                        <textarea class="form-control" name="competitors" rows="2" placeholder="e.g., https://competitor1.com, https://competitor2.com" required><?= esc($acct['competitors']) ?></textarea>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Your Brand Tagline (optional)</label>
                        <input class="form-control" name="tagline" value="<?= esc($acct['tagline']) ?>" type="text" placeholder="e.g., Quality You Can Trust"> 
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">Preferred Platforms</label>
                        <input class="form-control" name="platforms" value="<?= esc($acct['platforms']) ?>" type="text" placeholder="e.g., Instagram, Facebook, YouTube, WhatsApp" required>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">Business Vision (Next 1–2 Years)</label>
                        <textarea class="form-control" name="vision" rows="2" placeholder="What's your dream or goal for your business?" required><?= esc($acct['vision']) ?></textarea>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">Expected Customer Experience</label>
                        <textarea class="form-control" name="experience" rows="2" placeholder="What should people feel when they visit your brand?" required><?= esc($acct['experience']) ?></textarea>
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">Brand Uniqueness</label>
                        <textarea class="form-control" name="uniqueness" placeholder="What makes your business special to you?" rows="2" required><?= esc($acct['uniqueness']) ?></textarea>
                      </div>
                    </div>
                  </div>

                  <div class="app-divider-v mt-0 mb-0 pt-0"></div>
                  <h5 class="mb-2 text-dark f-w-600">Social Connections</h5>
                  <div class="row">
                      
                      <div class="col-lg-12 col-xxl-12 mb-4">
                        <div class="card conection-setting border">
                          <div class="card-body">
                            <div class="conection-item d-flex justify-content-between align-items-center">
                              <div class="d-flex align-items-center">
                                <img src="<?= base_url('assets/assets/images/setting-app/facebook.png') ?>" class="me-2" style="width:24px">
                                <h5 class="mb-0">Meta</h5>
                              </div>
                              <div class="form-check form-switch">
                                
                                <span class="form-check-label" >Required for instagram and facebook access</span>
                              </div>
                            </div>
                          </div>
                          <div class="card-footer text-end link-primary">
                            <div class="row">
                            <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                              <input class="form-control" name="meta_id" value="<?= esc($acct['meta_id'] ?? '') ?>" type="text">
                              <label>&nbsp;&nbsp; App ID</label>
                            </div>
                            <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                              <input class="form-control" name="meta_key" value="<?= esc($acct['meta_key'] ?? '') ?>" type="text">
                              <label>&nbsp;&nbsp; App Secret Key</label>
                            </div>
                            <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                              <input class="form-control" name="meta_token" value="<?= esc($acct['meta_token'] ?? '') ?>" type="text">
                              <label>&nbsp;&nbsp; Access Token</label>
                            </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      
                      <!-- Facebook -->
                      <div class="col-lg-6 col-xxl-6 mb-4">
                        <div class="card conection-setting border">
                          <div class="card-body">
                            <div class="conection-item d-flex justify-content-between align-items-center">
                              <div class="d-flex align-items-center">
                                <img src="<?= base_url('assets/assets/images/setting-app/facebook.png') ?>" class="me-2" style="width:24px">
                                <h5 class="mb-0">Facebook</h5>
                              </div>
                              <div class="form-check form-switch">
                                <input type="hidden" name="facebook_enabled" value="0">
                                <input class="form-check-input"
                                       id="switch-facebook-<?= $acct['id'] ?>"
                                       type="checkbox"
                                       name="facebook_enabled"
                                       value="1"
                                       <?= !empty($acct['facebook_enabled']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="switch-facebook-<?= $acct['id'] ?>"></label>
                              </div>
                            </div>
                          </div>
                          <div class="card-footer text-end link-primary">
                            
                            <div class="form-floating mb-3">
                              <input class="form-control" name="facebook_id" value="<?= esc($acct['facebook_id'] ?? '') ?>" type="text">
                              <label>Facebook ID</label>
                            </div>
                            <div class="form-floating my-3">
                              <input class="form-control" name="facebook_link" value="<?= esc($acct['facebook_link'] ?? '') ?>" type="url">
                              <label>Facebook URL</label>
                            </div>
                          </div>
                        </div>
                      </div>
                    
                      <!-- Instagram -->
                      <div class="col-lg-6 col-xxl-6 mb-4">
                        <div class="card conection-setting border">
                          <div class="card-body">
                            <div class="conection-item d-flex justify-content-between align-items-center">
                              <div class="d-flex align-items-center">
                                <img src="<?= base_url('assets/assets/images/setting-app/instagram.png') ?>" class="me-2" style="width:24px">
                                <h5 class="mb-0">Instagram</h5>
                              </div>
                              <div class="form-check form-switch">
                                <input type="hidden" name="instagram_enabled" value="0">
                                <input class="form-check-input"
                                       id="switch-instagram-<?= $acct['id'] ?>"
                                       type="checkbox"
                                       name="instagram_enabled"
                                       value="1"
                                       <?= !empty($acct['instagram_enabled']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="switch-instagram-<?= $acct['id'] ?>"></label>
                              </div>
                            </div>
                          </div>
                          <div class="card-footer text-end link-primary">
                            
                            <div class="form-floating mb-3">
                              <input class="form-control" name="instagram_id" value="<?= esc($acct['instagram_id'] ?? '') ?>" type="text">
                              <label>Instagram ID</label>
                            </div>
                            <div class="form-floating my-3">
                              <input class="form-control" name="instagram_link" value="<?= esc($acct['instagram_link'] ?? '') ?>" type="url">
                              <label>Instagram URL</label>
                            </div>
                          </div>
                        </div>
                      </div>
                    
                      <!-- Twitter -->
                      <div class="col-lg-6 col-xxl-6 mb-4">
                        <div class="card conection-setting border">
                          <div class="card-body">
                            <div class="conection-item d-flex justify-content-between align-items-center">
                              <div class="d-flex align-items-center">
                                <img src="<?= base_url('assets/assets/images/setting-app/twitter.png') ?>" class="me-2" style="width:24px">
                                <h5 class="mb-0">Twitter</h5>
                              </div>
                              <div class="form-check form-switch">
                                <input type="hidden" name="twitter_enabled" value="0">
                                <input class="form-check-input"
                                       id="switch-twitter-<?= $acct['id'] ?>"
                                       type="checkbox"
                                       name="twitter_enabled"
                                       value="1"
                                       <?= !empty($acct['twitter_enabled']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="switch-twitter-<?= $acct['id'] ?>"></label>
                              </div>
                            </div>
                          </div>
                          <div class="card-footer text-end link-primary">
                            <div class="form-floating my-3">
                              <input class="form-control" name="twitter_link" value="<?= esc($acct['twitter_link'] ?? '') ?>" type="url">
                              <label>Twitter URL</label>
                            </div>
                            <div class="form-floating mb-3">
                              <input class="form-control" name="twitter_api" value="<?= esc($acct['twitter_api'] ?? '') ?>" type="text">
                              <label>Twitter API</label>
                            </div>
                          </div>
                        </div>
                      </div>
                    
                      <!-- LinkedIn -->
                      <div class="col-lg-6 col-xxl-6 mb-4">
                        <div class="card conection-setting border">
                          <div class="card-body">
                            <div class="conection-item d-flex justify-content-between align-items-center">
                              <div class="d-flex align-items-center">
                                <img src="<?= base_url('assets/assets/images/setting-app/linkedin.png') ?>" class="me-2" style="width:24px">
                                <h5 class="mb-0">LinkedIn</h5>
                              </div>
                              <div class="form-check form-switch">
                                <input type="hidden" name="linkedin_enabled" value="0">
                                <input class="form-check-input"
                                       id="switch-linkedin-<?= $acct['id'] ?>"
                                       type="checkbox"
                                       name="linkedin_enabled"
                                       value="1"
                                       <?= !empty($acct['linkedin_enabled']) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="switch-linkedin-<?= $acct['id'] ?>"></label>
                              </div>
                            </div>
                          </div>
                          <div class="card-footer text-end link-primary">
                            <div class="form-floating my-3">
                              <input class="form-control" name="linkedin_link" value="<?= esc($acct['linkedin_link'] ?? '') ?>" type="url">
                              <label>LinkedIn URL</label>
                            </div>
                            <div class="form-floating mb-3">
                              <input class="form-control" name="linkedin_api" value="<?= esc($acct['linkedin_api'] ?? '') ?>" type="text">
                              <label>LinkedIn API</label>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>


                  <div class="text-end">
                    <button class="btn btn-primary" type="submit">Submit</button>
                  </div>
                </form>
              </div>
            </div>
            <?php $firstPane = false; ?>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</main>

<!-- TEMPLATE: new nav tab -->
<template id="tpl-new-tab">
  <li class="nav-item" role="presentation">
    <button
      class="nav-link"
      id="tab-new-__IDX__"
      data-bs-toggle="tab"
      data-bs-target="#panel-new-__IDX__"
      type="button"
      role="tab"
    >New Company</button>
  </li>
</template>

<!-- TEMPLATE: new pane -->
<template id="tpl-new-pane">
  <div class="tab-pane fade" id="panel-new-__IDX__" role="tabpanel">
    <div class="card p-4">
      <form class="app-form" method="post" action="<?= site_url('home/updatecompany') ?>" enctype="multipart/form-data">
        <input type="hidden" name="id" value="">
        <div class="row">
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Business Name</label><input class="form-control" name="name" type="text" placeholder="Your company name" required></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Industry / Niche</label><input class="form-control" name="industry" type="text" placeholder="e.g., Real Estate, Restaurant" required></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Upload Logo</label><div class="position-relative"><input class="form-control" name="logo" type="file" accept="image/*" onchange="previewLogo(event)"><img class="mt-2 img-fluid logo-preview" src="" style="display:none;"></div></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Preferred Brand Colors / Style</label><input class="form-control" name="colors" type="text" placeholder="e.g., Blue and White, Minimal, Bold"  required></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Location</label><input class="form-control" name="location" type="text" placeholder="City & Country"  required></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Target Audience</label><input class="form-control" name="audience" type="text" placeholder="e.g., college students, professionals" required></div></div>
          <div class="col-md-12"><label class="form-label">What do you want to increase?</label><div class="mb-3"><?php foreach(['Social Media Reach','Walk-ins / Footfall','Online Leads','Brand Awareness'] as $g): ?><div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="goals[]" value="<?= $g ?>"><label class="form-check-label"><?= $g ?></label></div><?php endforeach; ?></div></div>
          <div class="col-md-12"><div class="mb-3"><label class="form-label">Your Competitors (Links)</label><textarea class="form-control" name="competitors" rows="2" placeholder="e.g., https://competitor1.com, https://competitor2.com" required></textarea></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Your Brand Tagline (optional)</label><input class="form-control" name="tagline" type="text" placeholder="e.g., Quality You Can Trust"></div></div>
          <div class="col-md-6"><div class="mb-3"><label class="form-label">Preferred Platforms</label><input class="form-control" name="platforms" type="text" placeholder="e.g., Instagram, Facebook, YouTube, WhatsApp" required></div></div>
          <div class="col-md-12"><div class="mb-3"><label class="form-label">Business Vision (Next 1–2 Years)</label><textarea class="form-control" name="vision" rows="2" placeholder="What's your dream or goal for your business?" required></textarea></div></div>
          <div class="col-md-12"><div class="mb-3"><label class="form-label">Expected Customer Experience</label><textarea class="form-control" name="experience" rows="2" placeholder="What should people feel when they visit your brand?" required></textarea></div></div>
          <div class="col-md-12"><div class="mb-3"><label class="form-label">Brand Uniqueness</label><textarea class="form-control" name="uniqueness" rows="2" placeholder="What makes your business special to you?" required></textarea></div></div>
        </div>
        <div class="app-divider-v mt-0 mb-0 pt-0"></div>
        <h5 class="mb-2 text-dark f-w-600">Social Connections</h5>
        <div class="row">
            
          <div class="col-lg-12 col-xxl-12 mb-4">
            <div class="card conection-setting border">
              <div class="card-body">
                <div class="conection-item d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <img src="<?= base_url('assets/assets/images/setting-app/facebook.png') ?>" class="me-2" style="width:24px">
                    <h5 class="mb-0">Meta</h5>
                  </div>
                  <div class="form-check form-switch">
                    
                    <span class="form-check-label" >Required for instagram and facebook access</span>
                  </div>
                </div>
              </div>
              <div class="card-footer text-end link-primary">
                <div class="row">
                <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                  <input class="form-control" name="meta_id" value="<?= esc($acct['meta_id'] ?? '') ?>" type="text">
                  <label>&nbsp;&nbsp; App ID</label>
                </div>
                <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                  <input class="form-control" name="meta_key" value="<?= esc($acct['meta_key'] ?? '') ?>" type="text">
                  <label>&nbsp;&nbsp; App Secret Key</label>
                </div>
                <div class="col-lg-4 col-xxl-4  form-floating mb-1">
                  <input class="form-control" name="meta_token" value="<?= esc($acct['meta_token'] ?? '') ?>" type="text">
                  <label>&nbsp;&nbsp; Access Token</label>
                </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Facebook -->
          <div class="col-lg-6 col-xxl-6 mb-4">
            <div class="card conection-setting border">
              <div class="card-body">
                <div class="conection-item d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <img src="<?= base_url('assets/assets/images/setting-app/facebook.png') ?>" class="me-2" style="width:24px">
                    <h5 class="mb-0">Facebook</h5>
                  </div>
                  <div class="form-check form-switch">
                    <input type="hidden" name="facebook_enabled" value="0">
                    <input class="form-check-input"
                           id="switch-facebook-new-__IDX__"
                           type="checkbox"
                           name="facebook_enabled"
                           value="1">
                    <label class="form-check-label" for="switch-facebook-new-__IDX__"></label>
                  </div>
                </div>
              </div>
              <div class="card-footer text-end link-primary">
                
                <div class="form-floating mb-3">
                  <input class="form-control" name="facebook_id" type="text">
                  <label>Facebook ID</label>
                </div>
                <div class="form-floating my-3">
                  <input class="form-control" name="facebook_link" type="url">
                  <label>Facebook URL</label>
                </div>
              </div>
            </div>
          </div>
        
          <!-- Instagram -->
          <div class="col-lg-6 col-xxl-6 mb-4">
            <div class="card conection-setting border">
              <div class="card-body">
                <div class="conection-item d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <img src="<?= base_url('assets/assets/images/setting-app/instagram.png') ?>" class="me-2" style="width:24px">
                    <h5 class="mb-0">Instagram</h5>
                  </div>
                  <div class="form-check form-switch">
                    <input type="hidden" name="instagram_enabled" value="0">
                    <input class="form-check-input"
                           id="switch-instagram-new-__IDX__"
                           type="checkbox"
                           name="instagram_enabled"
                           value="1">
                    <label class="form-check-label" for="switch-instagram-new-__IDX__"></label>
                  </div>
                </div>
              </div>
              <div class="card-footer text-end link-primary">
                
                <div class="form-floating mb-3">
                  <input class="form-control" name="instagram_id" type="text">
                  <label>Instagram ID</label>
                </div>
                <div class="form-floating my-3">
                  <input class="form-control" name="instagram_link" type="url">
                  <label>Instagram URL</label>
                </div>
              </div>
            </div>
          </div>
        
          <!-- Twitter -->
          <div class="col-lg-6 col-xxl-6 mb-4">
            <div class="card conection-setting border">
              <div class="card-body">
                <div class="conection-item d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <img src="<?= base_url('assets/assets/images/setting-app/twitter.png') ?>" class="me-2" style="width:24px">
                    <h5 class="mb-0">Twitter</h5>
                  </div>
                  <div class="form-check form-switch">
                    <input type="hidden" name="twitter_enabled" value="0">
                    <input class="form-check-input"
                           id="switch-twitter-new-__IDX__"
                           type="checkbox"
                           name="twitter_enabled"
                           value="1">
                    <label class="form-check-label" for="switch-twitter-new-__IDX__"></label>
                  </div>
                </div>
              </div>
              <div class="card-footer text-end link-primary">
                <div class="form-floating my-3">
                  <input class="form-control" name="twitter_link" type="url">
                  <label>Twitter URL</label>
                </div>
                <div class="form-floating mb-3">
                  <input class="form-control" name="twitter_api" type="text">
                  <label>Twitter API</label>
                </div>
              </div>
            </div>
          </div>
        
          <!-- LinkedIn -->
          <div class="col-lg-6 col-xxl-6 mb-4">
            <div class="card conection-setting border">
              <div class="card-body">
                <div class="conection-item d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <img src="<?= base_url('assets/assets/images/setting-app/linkedin.png') ?>" class="me-2" style="width:24px">
                    <h5 class="mb-0">LinkedIn</h5>
                  </div>
                  <div class="form-check form-switch">
                    <input type="hidden" name="linkedin_enabled" value="0">
                    <input class="form-check-input"
                           id="switch-linkedin-new-__IDX__"
                           type="checkbox"
                           name="linkedin_enabled"
                           value="1">
                    <label class="form-check-label" for="switch-linkedin-new-__IDX__"></label>
                  </div>
                </div>
              </div>
              <div class="card-footer text-end link-primary">
                <div class="form-floating my-3">
                  <input class="form-control" name="linkedin_link" type="url">
                  <label>LinkedIn URL</label>
                </div>
                <div class="form-floating mb-3">
                  <input class="form-control" name="linkedin_api" type="text">
                  <label>LinkedIn API</label>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="text-end"><button class="btn btn-primary">Save</button></div>
      </form>
    </div>
  </div>
</template>

<script>
  (function(){
    let nextIdx   = Date.now();
    const tabsEl    = document.getElementById('companyTabs');
    const contentEl = document.getElementById('companyContent');
    const btn       = document.getElementById('addCompanyBtn');
    const tplTab    = document.getElementById('tpl-new-tab').innerHTML;
    const tplPane   = document.getElementById('tpl-new-pane').innerHTML;

    btn.addEventListener('click', ()=>{
      const idx = nextIdx++;
      tabsEl.insertAdjacentHTML('beforeend', tplTab.replace(/__IDX__/g, idx));
      contentEl.insertAdjacentHTML('beforeend', tplPane.replace(/__IDX__/g, idx));
      const tabBtn = document.getElementById(`tab-new-${idx}`);
      new bootstrap.Tab(tabBtn).show();
    });
  })();

  // live preview for each file input
  function previewLogo(event) {
    const [file] = event.target.files;
    if (!file) return;
    const container = event.target.closest('.mb-3');
    const preview   = container.querySelector('img.logo-preview');
    preview.src     = URL.createObjectURL(file);
    preview.style.display = 'block';
  }
</script>

<?php include('footer.php') ?>
