<?php
/**
 * SignHashSessionInfoResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.13-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * SignHashSessionInfoResponse Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SignHashSessionInfoResponse implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'signHashSessionInfoResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'documents' => '\DocuSign\eSign\Model\SignHashDocument[]',
        'envelope_id' => '?string',
        'language' => '?string',
        'redirection_url' => '?string',
        'remaining_signature_requests' => 'int',
        'seal' => '\DocuSign\eSign\Model\Seal',
        'sender' => '\DocuSign\eSign\Model\Sender',
        'user' => '\DocuSign\eSign\Model\User'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'documents' => null,
        'envelope_id' => null,
        'language' => null,
        'redirection_url' => null,
        'remaining_signature_requests' => 'int64',
        'seal' => null,
        'sender' => null,
        'user' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'documents' => 'documents',
        'envelope_id' => 'envelopeId',
        'language' => 'language',
        'redirection_url' => 'redirectionUrl',
        'remaining_signature_requests' => 'remainingSignatureRequests',
        'seal' => 'seal',
        'sender' => 'sender',
        'user' => 'user'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'documents' => 'setDocuments',
        'envelope_id' => 'setEnvelopeId',
        'language' => 'setLanguage',
        'redirection_url' => 'setRedirectionUrl',
        'remaining_signature_requests' => 'setRemainingSignatureRequests',
        'seal' => 'setSeal',
        'sender' => 'setSender',
        'user' => 'setUser'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'documents' => 'getDocuments',
        'envelope_id' => 'getEnvelopeId',
        'language' => 'getLanguage',
        'redirection_url' => 'getRedirectionUrl',
        'remaining_signature_requests' => 'getRemainingSignatureRequests',
        'seal' => 'getSeal',
        'sender' => 'getSender',
        'user' => 'getUser'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['documents'] = isset($data['documents']) ? $data['documents'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['redirection_url'] = isset($data['redirection_url']) ? $data['redirection_url'] : null;
        $this->container['remaining_signature_requests'] = isset($data['remaining_signature_requests']) ? $data['remaining_signature_requests'] : null;
        $this->container['seal'] = isset($data['seal']) ? $data['seal'] : null;
        $this->container['sender'] = isset($data['sender']) ? $data['sender'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets documents
     *
     * @return \DocuSign\eSign\Model\SignHashDocument[]
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     *
     * @param \DocuSign\eSign\Model\SignHashDocument[] $documents Complex element contains the details on the documents in the envelope.
     *
     * @return $this
     */
    public function setDocuments($documents)
    {
        $this->container['documents'] = $documents;

        return $this;
    }

    /**
     * Gets envelope_id
     *
     * @return ?string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     *
     * @param ?string $envelope_id The envelope ID of the envelope status that failed to post.
     *
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets language
     *
     * @return ?string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param ?string $language 
     *
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets redirection_url
     *
     * @return ?string
     */
    public function getRedirectionUrl()
    {
        return $this->container['redirection_url'];
    }

    /**
     * Sets redirection_url
     *
     * @param ?string $redirection_url 
     *
     * @return $this
     */
    public function setRedirectionUrl($redirection_url)
    {
        $this->container['redirection_url'] = $redirection_url;

        return $this;
    }

    /**
     * Gets remaining_signature_requests
     *
     * @return int
     */
    public function getRemainingSignatureRequests()
    {
        return $this->container['remaining_signature_requests'];
    }

    /**
     * Sets remaining_signature_requests
     *
     * @param int $remaining_signature_requests 
     *
     * @return $this
     */
    public function setRemainingSignatureRequests($remaining_signature_requests)
    {
        $this->container['remaining_signature_requests'] = $remaining_signature_requests;

        return $this;
    }

    /**
     * Gets seal
     *
     * @return \DocuSign\eSign\Model\Seal
     */
    public function getSeal()
    {
        return $this->container['seal'];
    }

    /**
     * Sets seal
     *
     * @param \DocuSign\eSign\Model\Seal $seal seal
     *
     * @return $this
     */
    public function setSeal($seal)
    {
        $this->container['seal'] = $seal;

        return $this;
    }

    /**
     * Gets sender
     *
     * @return \DocuSign\eSign\Model\Sender
     */
    public function getSender()
    {
        return $this->container['sender'];
    }

    /**
     * Sets sender
     *
     * @param \DocuSign\eSign\Model\Sender $sender sender
     *
     * @return $this
     */
    public function setSender($sender)
    {
        $this->container['sender'] = $sender;

        return $this;
    }

    /**
     * Gets user
     *
     * @return \DocuSign\eSign\Model\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     *
     * @param \DocuSign\eSign\Model\User $user user
     *
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

