<?php
/**
 * ListItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * ListItem Class Doc Comment
 *
 * @category    Class
 * @description One of the selectable items in the &#x60;listItems&#x60; property of a [&#x60;list&#x60;](/docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/create/) tab.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ListItem implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'listItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'selected' => '?string',
        'selected_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'text' => '?string',
        'text_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'value' => '?string',
        'value_metadata' => '\DocuSign\eSign\Model\PropertyMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'selected' => null,
        'selected_metadata' => null,
        'text' => null,
        'text_metadata' => null,
        'value' => null,
        'value_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'selected' => 'selected',
        'selected_metadata' => 'selectedMetadata',
        'text' => 'text',
        'text_metadata' => 'textMetadata',
        'value' => 'value',
        'value_metadata' => 'valueMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'selected' => 'setSelected',
        'selected_metadata' => 'setSelectedMetadata',
        'text' => 'setText',
        'text_metadata' => 'setTextMetadata',
        'value' => 'setValue',
        'value_metadata' => 'setValueMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'selected' => 'getSelected',
        'selected_metadata' => 'getSelectedMetadata',
        'text' => 'getText',
        'text_metadata' => 'getTextMetadata',
        'value' => 'getValue',
        'value_metadata' => 'getValueMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['selected'] = isset($data['selected']) ? $data['selected'] : null;
        $this->container['selected_metadata'] = isset($data['selected_metadata']) ? $data['selected_metadata'] : null;
        $this->container['text'] = isset($data['text']) ? $data['text'] : null;
        $this->container['text_metadata'] = isset($data['text_metadata']) ? $data['text_metadata'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['value_metadata'] = isset($data['value_metadata']) ? $data['value_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets selected
     *
     * @return ?string
     */
    public function getSelected()
    {
        return $this->container['selected'];
    }

    /**
     * Sets selected
     *
     * @param ?string $selected When set to **true**, indicates that this item is the default selection shown to a signer.   Only one selection can be set as the default.
     *
     * @return $this
     */
    public function setSelected($selected)
    {
        $this->container['selected'] = $selected;

        return $this;
    }

    /**
     * Gets selected_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getSelectedMetadata()
    {
        return $this->container['selected_metadata'];
    }

    /**
     * Sets selected_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $selected_metadata Metadata that indicates whether the `selected` property is editable.
     *
     * @return $this
     */
    public function setSelectedMetadata($selected_metadata)
    {
        $this->container['selected_metadata'] = $selected_metadata;

        return $this;
    }

    /**
     * Gets text
     *
     * @return ?string
     */
    public function getText()
    {
        return $this->container['text'];
    }

    /**
     * Sets text
     *
     * @param ?string $text Specifies the text that is shown in the dropdown list.
     *
     * @return $this
     */
    public function setText($text)
    {
        $this->container['text'] = $text;

        return $this;
    }

    /**
     * Gets text_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getTextMetadata()
    {
        return $this->container['text_metadata'];
    }

    /**
     * Sets text_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $text_metadata 
     *
     * @return $this
     */
    public function setTextMetadata($text_metadata)
    {
        $this->container['text_metadata'] = $text_metadata;

        return $this;
    }

    /**
     * Gets value
     *
     * @return ?string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param ?string $value Specifies the value that is used when the list item is selected.
     *
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets value_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getValueMetadata()
    {
        return $this->container['value_metadata'];
    }

    /**
     * Sets value_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $value_metadata Metadata that indicates whether the `value` property is editable.
     *
     * @return $this
     */
    public function setValueMetadata($value_metadata)
    {
        $this->container['value_metadata'] = $value_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

