<?php
/**
 * DisplayApplianceDocument
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * DisplayApplianceDocument Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DisplayApplianceDocument implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'displayApplianceDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'attachment_description' => 'string',
        'document_id' => 'string',
        'document_type' => 'string',
        'envelope_id' => 'string',
        'external_document_id' => 'string',
        'latest_pdf_id' => 'string',
        'name' => 'string',
        'pages' => 'int'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'attachment_description' => 'attachmentDescription',
        'document_id' => 'documentId',
        'document_type' => 'documentType',
        'envelope_id' => 'envelopeId',
        'external_document_id' => 'externalDocumentId',
        'latest_pdf_id' => 'latestPDFId',
        'name' => 'name',
        'pages' => 'pages'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'attachment_description' => 'setAttachmentDescription',
        'document_id' => 'setDocumentId',
        'document_type' => 'setDocumentType',
        'envelope_id' => 'setEnvelopeId',
        'external_document_id' => 'setExternalDocumentId',
        'latest_pdf_id' => 'setLatestPdfId',
        'name' => 'setName',
        'pages' => 'setPages'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'attachment_description' => 'getAttachmentDescription',
        'document_id' => 'getDocumentId',
        'document_type' => 'getDocumentType',
        'envelope_id' => 'getEnvelopeId',
        'external_document_id' => 'getExternalDocumentId',
        'latest_pdf_id' => 'getLatestPdfId',
        'name' => 'getName',
        'pages' => 'getPages'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['attachment_description'] = isset($data['attachment_description']) ? $data['attachment_description'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['document_type'] = isset($data['document_type']) ? $data['document_type'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['external_document_id'] = isset($data['external_document_id']) ? $data['external_document_id'] : null;
        $this->container['latest_pdf_id'] = isset($data['latest_pdf_id']) ? $data['latest_pdf_id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['pages'] = isset($data['pages']) ? $data['pages'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets attachment_description
     * @return string
     */
    public function getAttachmentDescription()
    {
        return $this->container['attachment_description'];
    }

    /**
     * Sets attachment_description
     * @param string $attachment_description 
     * @return $this
     */
    public function setAttachmentDescription($attachment_description)
    {
        $this->container['attachment_description'] = $attachment_description;

        return $this;
    }

    /**
     * Gets document_id
     * @return string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     * @param string $document_id Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets document_type
     * @return string
     */
    public function getDocumentType()
    {
        return $this->container['document_type'];
    }

    /**
     * Sets document_type
     * @param string $document_type 
     * @return $this
     */
    public function setDocumentType($document_type)
    {
        $this->container['document_type'] = $document_type;

        return $this;
    }

    /**
     * Gets envelope_id
     * @return string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     * @param string $envelope_id The envelope ID of the envelope status that failed to post.
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets external_document_id
     * @return string
     */
    public function getExternalDocumentId()
    {
        return $this->container['external_document_id'];
    }

    /**
     * Sets external_document_id
     * @param string $external_document_id 
     * @return $this
     */
    public function setExternalDocumentId($external_document_id)
    {
        $this->container['external_document_id'] = $external_document_id;

        return $this;
    }

    /**
     * Gets latest_pdf_id
     * @return string
     */
    public function getLatestPdfId()
    {
        return $this->container['latest_pdf_id'];
    }

    /**
     * Sets latest_pdf_id
     * @param string $latest_pdf_id 
     * @return $this
     */
    public function setLatestPdfId($latest_pdf_id)
    {
        $this->container['latest_pdf_id'] = $latest_pdf_id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name 
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets pages
     * @return int
     */
    public function getPages()
    {
        return $this->container['pages'];
    }

    /**
     * Sets pages
     * @param int $pages 
     * @return $this
     */
    public function setPages($pages)
    {
        $this->container['pages'] = $pages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


