<?php
// /ai-chatbot-starter/api/oauth_start.php
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/config.php';

session_start();

$client = new Google_Client();
$client->setApplicationName('Rovix AI');
$client->setAuthConfig($GOOGLE_OAUTH_CLIENT);
$client->setScopes(['https://www.googleapis.com/auth/calendar']);
$client->setAccessType('offline');      // get refresh token
$client->setPrompt('consent');          // ensure refresh_token on first run
$client->setRedirectUri((isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/ai-chatbot-starter/api/oauth_callback.php');

$authUrl = $client->createAuthUrl();
header('Location: ' . $authUrl);
exit;
