<?php
// db.php
require_once __DIR__.'/config.php';

function db(){
  static $pdo = null;
  global $DB_HOST, $DB_NAME, $DB_USER, $DB_PASS;
  if($pdo === null){
    $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";
    $options = [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false,
    ];
    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, $options);
  }
  return $pdo;
}

// New function to check if a lead exists
function db_find_lead_by_email_and_service($email, $service){
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id FROM leads WHERE email = ? AND service = ? LIMIT 1");
  $stmt->execute([$email, $service]);
  $row = $stmt->fetch();
  return $row ? $row['id'] : false;
}

// Function to update lead
function db_update_lead($lead_id, $name, $email, $phone, $service, $date, $time){
  $pdo = db();
  $stmt = $pdo->prepare("UPDATE leads SET name = ?, phone = ?, service = ?, date = ?, time = ? WHERE id = ?");
  $stmt->execute([$name, $phone, $service, $date, $time, $lead_id]);
  return $stmt->rowCount();
}

// Existing functions
function db_find_or_create_conversation($session_id, $channel='web'){
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id FROM conversations WHERE session_id = ? LIMIT 1");
  $stmt->execute([$session_id]);
  $row = $stmt->fetch();
  if($row){ return (int)$row['id']; }
  $stmt = $pdo->prepare("INSERT INTO conversations (session_id, channel) VALUES (?, ?)"); 
  $stmt->execute([$session_id, $channel]);
  return (int)$pdo->lastInsertId();
}

function db_insert_message($conversation_id, $role, $content){
  $pdo = db();
  $stmt = $pdo->prepare("INSERT INTO messages (conversation_id, role, content) VALUES (?, ?, ?)"); 
  $stmt->execute([$conversation_id, $role, $content]);
}

function db_last_messages($conversation_id, $limit=12){
  $pdo = db();
  $stmt = $pdo->prepare("SELECT role, content FROM messages WHERE conversation_id = ? ORDER BY id DESC LIMIT ?");
  $stmt->bindValue(1, $conversation_id, PDO::PARAM_INT);
  $stmt->bindValue(2, $limit, PDO::PARAM_INT);
  $stmt->execute();
  $rows = $stmt->fetchAll();
  return array_reverse($rows);
}

function db_insert_lead($conversation_id, $name, $email, $phone, $service, $date, $time){
  try {
    $pdo = db();
    $stmt = $pdo->prepare("INSERT INTO leads (conversation_id, name, email, phone, service, date, time) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$conversation_id, $name, $email, $phone, $service, $date, $time]);
    return (int)$pdo->lastInsertId();
  } catch (Exception $e) {
    error_log('Error inserting lead: ' . $e->getMessage());
    return false;
  }
}
?>
