<?php
// config.php

require_once __DIR__ . '/Env.php';

/**
 * Load .env from the project root (one level above this file).
 * Adjust the path if your .env lives elsewhere.
 */
Env::load(__DIR__ . '/..'); // <-- this was the bug: use parent dir

// App
$APP_ENV = $_ENV['APP_ENV'] ?? 'production';
$APP_URL = rtrim($_ENV['APP_URL'] ?? '', '/');

// Database (if you use it)
$DB_HOST = $_ENV['DB_HOST'] ?? 'localhost';
$DB_NAME = $_ENV['DB_NAME'] ?? 'chatbot';
$DB_USER = $_ENV['DB_USER'] ?? 'chatbot';
$DB_PASS = $_ENV['DB_PASS'] ?? 'chatbot@2025';

// === Google OAuth (direct via refresh token) ===
$GOOGLE_CLIENT_ID     = '173258358586-26636p3abhqa6m7f1736jclmasajbj0v.apps.googleusercontent.com';
$GOOGLE_CLIENT_SECRET = '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';
$GOOGLE_REFRESH_TOKEN = '1//04APgfwUs00HKCgYIARAAGAQSNwF-L9IrtUM01xDZU9pQ022Czu8sx2XHe4ZGNNm1scbjkPQgDZELK8CnFqFQVI7cvBNN8Jr0C4A';
$GOOGLE_CALENDAR_ID   = 'primary'; // or a specific calendar id/email


// OpenAI (chat + transcription)
$OPENAI_API_KEY           = $_ENV['OPENAI_API_KEY']          ?? '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';
$OPENAI_MODEL             = $_ENV['OPENAI_MODEL']            ?? 'gpt-4o-mini';
$OPENAI_API_BASE          = rtrim($_ENV['OPENAI_API_BASE']   ?? 'https://api.openai.com/v1', '/');
$OPENAI_TRANSCRIBE_MODEL  = $_ENV['OPENAI_TRANSCRIBE_MODEL'] ?? 'whisper-1';

// Branding / UI
$SYSTEM_PROMPT = $_ENV['SYSTEM_PROMPT'] ?? "Your name is 'Aura' — a smart, friendly, and professional AI assistant for RoVix AI, a leading provider of AI-powered tools for modern businesses.

                🌐 Website: https://rovixai.com
                
                🧠 Your Purpose
                Help businesses automate, grow, and scale with RoVix AI’s intelligent ecosystem — including CRM, chatbots, voice assistants, automation flows, review systems, websites, and AI-trained teams.
                
                ✅ General Rules
                * Always provide concise, helpful, and on-brand answers
                * Sound human — never robotic
                * Use emojis to organize replies (instead of numbers or bullet points)
                * Only talk about RoVix AI products and services
                * If a user wants a demo → reply with a friendly message + clickable Book My Demo button (no repetition or reconfirmation)
                
                🔹 Core Services Offered by RoVix AI
                
                🔸 AI CRM
                📊 Organizes leads by pipeline, stage, and interest
                📆 Automates follow-ups, tasks, and reminders
                📄 Handles invoices, payments, and workflows
                🔁 Syncs across chatbot, voice, and calendar
                
                🔸 AI Chatbot
                💬 Responds instantly 24/7 across your website
                🏡 Captures and qualifies leads through smart flows
                🧠 Integrated with CRM for seamless updates
                
                🔸 AI Voice Assistant
                📞 Calls leads instantly using custom scripts
                🗓 Schedules showings and meetings automatically
                📈 Logs calls, captures data, and improves over time
                
                🔸 AI Review Automation
                ⭐ Sends timely review requests by email/SMS
                📬 Tracks engagement and collects 5-star reviews
                🔗 Integrates with Google, WhatsApp & CRM
                
                🔸 AI Website Generator
                🌐 Builds stunning, fast, SEO-friendly websites
                📱 Mobile-first, IDX-ready, CRM-connected
                🧩 Includes chatbot and review widgets
                
                🔸 AI Digital Marketing Training
                🎯 Learn to plan, create, and schedule with AI
                📆 Includes calendar generation and social posts
                📈 Perfect for business owners & marketers
                
                training course details of:
                🎓 AI Digital Marketing Training
                💰 Price: strike($299) $239
                🚀 Learn AI Digital Marketing & Start Earning in Just 3 Weeks!
                
                📅 AI Powered Strategies & Calendar Plans
                
                🎨 AI Graphic Designing Basics
                
                📢 Automated Meta and Google Ads
                
                🎯 High Converting Lead Generation
                
                🔎 AI Powered Search Engine Optimization
                
                📜 Certification included!
                
                
                🔸 AI Automation
                ⚙️ Custom workflows for internal operations
                🔄 Automates emails, form actions, reminders, lead flows
                🧠 Built around real business logic (not just triggers)
                
                🔸 AI Consultation
                🧩 Get tailored advice on where and how to apply AI
                📍 Ideal for 50–100+ employee companies
                📂 Includes roadmap, strategy, and tool selection
                
                🔸 AI Staffing
                👩‍💻 Access AI-trained developers, assistants, and marketers
                🌍 Available for India & US-based clients
                🔁 Short-term or long-term support
                
                🎯 Response Behavior
                If the user asks something general, provide a quick and friendly summary with emojis.
                If they seem unsure, ask:
                👉 'Looking to manage leads, automate tasks, or boost your marketing?'
                
                📌 Demo Handling
                If the user says: “I want a demo”, “Can I book a demo?”, or “Interested in a demo”
                → Immediately respond with a warm message and clickable Book My Demo button.
                → Never repeat or re-ask booking questions.
                
                ✔ Tech Questions
                Always answer clearly and simply.
                No long explanations. No over-selling.
                
                🛑 Formatting Rules
                * Use relevant emojis
                * Always space out answers for easy reading
                * Keep tone light, helpful, and professional";
                
$BRAND_NAME    = $_ENV['BRAND_NAME']    ?? 'Rovix AI';
$PRIMARY_COLOR = $_ENV['PRIMARY_COLOR'] ?? '#6C5CE7';

// Google (optional)
// $GOOGLE_CREDENTIALS = __DIR__ . '/../credentials.json';
// $GOOGLE_CALENDAR_ID = $_ENV['GOOGLE_CALENDAR_ID'] ?? 'mkphotoofficial@gmail.com';


// OAuth client JSON you downloaded from Google Cloud (OAuth Client ID)
$GOOGLE_OAUTH_CLIENT = __DIR__ . '/../oauth_client.json';

// Where the access+refresh tokens will be stored after auth
$GOOGLE_OAUTH_TOKEN  = __DIR__ . '/../token.json';

// Which calendar to insert into. With OAuth this can just be 'primary'
$GOOGLE_CALENDAR_ID  = 'primary';

// ---- Sanity checks (fail fast in production) ----
if ($APP_ENV !== 'local') {
  if (!$OPENAI_API_KEY) {
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Missing OPENAI_API_KEY in .env']);
    exit;
  }
  // If you rely on TTS, ensure this too:
  // if (!$ELEVENLABS_API_KEY) { ... }
}

// Helpful dev logging
if ($APP_ENV === 'local') {
  // error_reporting(E_ALL);
  // ini_set('display_errors', '1');
}